# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP DOMSnapshot Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .types import ComputedStyle
    from .types import DOMNode
    from .types import DocumentSnapshot
    from .types import LayoutTreeNode

class GetSnapshotParameters(TypedDict):
    computedStyleWhitelist: "List[str]"
    """Whitelist of computed styles to return."""
    includeEventListeners: "NotRequired[bool]"
    """Whether or not to retrieve details of DOM listeners (default false)."""
    includePaintOrder: "NotRequired[bool]"
    """Whether to determine and include the paint order index of LayoutTreeNodes (default false)."""
    includeUserAgentShadowTree: "NotRequired[bool]"
    """Whether to include UA shadow tree in the snapshot (default false)."""


class GetSnapshotReturns(TypedDict):
    domNodes: "List[DOMNode]"
    """The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document."""
    layoutTreeNodes: "List[LayoutTreeNode]"
    """The nodes in the layout tree."""
    computedStyles: "List[ComputedStyle]"
    """Whitelisted ComputedStyle properties for each node in the layout tree."""



class CaptureSnapshotParameters(TypedDict):
    computedStyles: "List[str]"
    """Whitelist of computed styles to return."""
    includePaintOrder: "NotRequired[bool]"
    """Whether to include layout object paint orders into the snapshot."""
    includeDOMRects: "NotRequired[bool]"
    """Whether to include DOM rectangles (offsetRects, clientRects, scrollRects) into the snapshot"""
    includeBlendedBackgroundColors: "NotRequired[bool]"
    """Whether to include blended background colors in the snapshot (default: false).
Blended background color is achieved by blending background colors of all elements
that overlap with the current element."""
    includeTextColorOpacities: "NotRequired[bool]"
    """Whether to include text color opacity in the snapshot (default: false).
An element might have the opacity property set that affects the text color of the element.
The final text color opacity is computed based on the opacity of all overlapping elements."""


class CaptureSnapshotReturns(TypedDict):
    documents: "List[DocumentSnapshot]"
    """The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document."""
    strings: "List[str]"
    """Shared string table that all string properties refer to with indexes."""
