# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP DOMSnapshot Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import CaptureSnapshotParameters
    from .commands import CaptureSnapshotReturns
    from .commands import GetSnapshotParameters
    from .commands import GetSnapshotReturns

class DOMSnapshotClient:
    """Client for DOMSnapshot domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables DOM snapshot agent for the given page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOMSnapshot.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables DOM snapshot agent for the given page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOMSnapshot.enable",
            params=params,
            session_id=session_id,
        ))

    async def getSnapshot(
        self,
        params: "GetSnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "GetSnapshotReturns":
        """Returns a document snapshot, including the full DOM tree of the root node (including iframes,
template contents, and imported documents) in a flattened array, as well as layout and
white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
flattened."""
        return cast("GetSnapshotReturns", await self._client.send_raw(
            method="DOMSnapshot.getSnapshot",
            params=params,
            session_id=session_id,
        ))

    async def captureSnapshot(
        self,
        params: "CaptureSnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "CaptureSnapshotReturns":
        """Returns a document snapshot, including the full DOM tree of the root node (including iframes,
template contents, and imported documents) in a flattened array, as well as layout and
white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
flattened."""
        return cast("CaptureSnapshotReturns", await self._client.send_raw(
            method="DOMSnapshot.captureSnapshot",
            params=params,
            session_id=session_id,
        ))


