# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Fetch Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import ContinueRequestParameters
    from .commands import ContinueResponseParameters
    from .commands import ContinueWithAuthParameters
    from .commands import EnableParameters
    from .commands import FailRequestParameters
    from .commands import FulfillRequestParameters
    from .commands import GetResponseBodyParameters
    from .commands import GetResponseBodyReturns
    from .commands import TakeResponseBodyAsStreamParameters
    from .commands import TakeResponseBodyAsStreamReturns

class FetchClient:
    """Client for Fetch domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables the fetch domain."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: Optional["EnableParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables issuing of requestPaused events. A request will be paused until client
calls one of failRequest, fulfillRequest or continueRequest/continueWithAuth."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.enable",
            params=params,
            session_id=session_id,
        ))

    async def failRequest(
        self,
        params: "FailRequestParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Causes the request to fail with specified reason."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.failRequest",
            params=params,
            session_id=session_id,
        ))

    async def fulfillRequest(
        self,
        params: "FulfillRequestParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Provides response to the request."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.fulfillRequest",
            params=params,
            session_id=session_id,
        ))

    async def continueRequest(
        self,
        params: "ContinueRequestParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Continues the request, optionally modifying some of its parameters."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.continueRequest",
            params=params,
            session_id=session_id,
        ))

    async def continueWithAuth(
        self,
        params: "ContinueWithAuthParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Continues a request supplying authChallengeResponse following authRequired event."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.continueWithAuth",
            params=params,
            session_id=session_id,
        ))

    async def continueResponse(
        self,
        params: "ContinueResponseParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Continues loading of the paused response, optionally modifying the
response headers. If either responseCode or headers are modified, all of them
must be present."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Fetch.continueResponse",
            params=params,
            session_id=session_id,
        ))

    async def getResponseBody(
        self,
        params: "GetResponseBodyParameters",
        session_id: Optional[str] = None,
    ) -> "GetResponseBodyReturns":
        """Causes the body of the response to be received from the server and
returned as a single string. May only be issued for a request that
is paused in the Response stage and is mutually exclusive with
takeResponseBodyForInterceptionAsStream. Calling other methods that
affect the request or disabling fetch domain before body is received
results in an undefined behavior.
Note that the response body is not available for redirects. Requests
paused in the _redirect received_ state may be differentiated by
`responseCode` and presence of `location` response header, see
comments to `requestPaused` for details."""
        return cast("GetResponseBodyReturns", await self._client.send_raw(
            method="Fetch.getResponseBody",
            params=params,
            session_id=session_id,
        ))

    async def takeResponseBodyAsStream(
        self,
        params: "TakeResponseBodyAsStreamParameters",
        session_id: Optional[str] = None,
    ) -> "TakeResponseBodyAsStreamReturns":
        """Returns a handle to the stream representing the response body.
The request must be paused in the HeadersReceived stage.
Note that after this command the request can't be continued
as is -- client either needs to cancel it or to provide the
response body.
The stream only supports sequential read, IO.read will fail if the position
is specified.
This method is mutually exclusive with getResponseBody.
Calling other methods that affect the request or disabling fetch
domain before body is received results in an undefined behavior."""
        return cast("TakeResponseBodyAsStreamReturns", await self._client.send_raw(
            method="Fetch.takeResponseBodyAsStream",
            params=params,
            session_id=session_id,
        ))


