# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP HeadlessExperimental Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import BeginFrameParameters
    from .commands import BeginFrameReturns

class HeadlessExperimentalClient:
    """Client for HeadlessExperimental domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def beginFrame(
        self,
        params: Optional["BeginFrameParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "BeginFrameReturns":
        """Sends a BeginFrame to the target and returns when the frame was completed. Optionally captures a
screenshot from the resulting frame. Requires that the target was created with enabled
BeginFrameControl. Designed for use with --run-all-compositor-stages-before-draw, see also
https://goo.gle/chrome-headless-rendering for more background."""
        return cast("BeginFrameReturns", await self._client.send_raw(
            method="HeadlessExperimental.beginFrame",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables headless events for the target."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeadlessExperimental.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables headless events for the target."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeadlessExperimental.enable",
            params=params,
            session_id=session_id,
        ))


