# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP IndexedDB Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..storage.types import StorageBucket
    from .types import DataEntry
    from .types import DatabaseWithObjectStores
    from .types import KeyRange

class ClearObjectStoreParameters(TypedDict):
    securityOrigin: "NotRequired[str]"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "NotRequired[str]"
    """Storage key."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket. If not specified, it uses the default bucket."""
    databaseName: "str"
    """Database name."""
    objectStoreName: "str"
    """Object store name."""





class DeleteDatabaseParameters(TypedDict):
    securityOrigin: "NotRequired[str]"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "NotRequired[str]"
    """Storage key."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket. If not specified, it uses the default bucket."""
    databaseName: "str"
    """Database name."""





class DeleteObjectStoreEntriesParameters(TypedDict):
    securityOrigin: "NotRequired[str]"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "NotRequired[str]"
    """Storage key."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket. If not specified, it uses the default bucket."""
    databaseName: "str"
    objectStoreName: "str"
    keyRange: "KeyRange"
    """Range of entry keys to delete"""





class RequestDataParameters(TypedDict):
    securityOrigin: "NotRequired[str]"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "NotRequired[str]"
    """Storage key."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket. If not specified, it uses the default bucket."""
    databaseName: "str"
    """Database name."""
    objectStoreName: "str"
    """Object store name."""
    indexName: "str"
    """Index name, empty string for object store data requests."""
    skipCount: "int"
    """Number of records to skip."""
    pageSize: "int"
    """Number of records to fetch."""
    keyRange: "NotRequired[KeyRange]"
    """Key range."""


class RequestDataReturns(TypedDict):
    objectStoreDataEntries: "List[DataEntry]"
    """Array of object store data entries."""
    hasMore: "bool"
    """If true, there are more entries to fetch in the given range."""



class GetMetadataParameters(TypedDict):
    securityOrigin: "NotRequired[str]"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "NotRequired[str]"
    """Storage key."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket. If not specified, it uses the default bucket."""
    databaseName: "str"
    """Database name."""
    objectStoreName: "str"
    """Object store name."""


class GetMetadataReturns(TypedDict):
    entriesCount: "float"
    """the entries count"""
    keyGeneratorValue: "float"
    """the current value of key generator, to become the next inserted
key into the object store. Valid if objectStore.autoIncrement
is true."""



class RequestDatabaseParameters(TypedDict):
    securityOrigin: "NotRequired[str]"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "NotRequired[str]"
    """Storage key."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket. If not specified, it uses the default bucket."""
    databaseName: "str"
    """Database name."""


class RequestDatabaseReturns(TypedDict):
    databaseWithObjectStores: "DatabaseWithObjectStores"
    """Database with an array of object stores."""



class RequestDatabaseNamesParameters(TypedDict, total=False):
    securityOrigin: "str"
    """At least and at most one of securityOrigin, storageKey, or storageBucket must be specified.
Security origin."""
    storageKey: "str"
    """Storage key."""
    storageBucket: "StorageBucket"
    """Storage bucket. If not specified, it uses the default bucket."""


class RequestDatabaseNamesReturns(TypedDict):
    databaseNames: "List[str]"
    """Database names for origin."""
