# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Input Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .types import DragData
    from .types import GestureSourceType
    from .types import MouseButton
    from .types import TimeSinceEpoch
    from .types import TouchPoint

class DispatchDragEventParameters(TypedDict):
    type: "str"
    """Type of the drag event."""
    x: "float"
    """X coordinate of the event relative to the main frame's viewport in CSS pixels."""
    y: "float"
    """Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
the top of the viewport and Y increases as it proceeds towards the bottom of the viewport."""
    data: "DragData"
    modifiers: "NotRequired[int]"
    """Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
(default: 0)."""





class DispatchKeyEventParameters(TypedDict):
    type: "str"
    """Type of the key event."""
    modifiers: "NotRequired[int]"
    """Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
(default: 0)."""
    timestamp: "NotRequired[TimeSinceEpoch]"
    """Time at which the event occurred."""
    text: "NotRequired[str]"
    """Text as generated by processing a virtual key code with a keyboard layout. Not needed for
for `keyUp` and `rawKeyDown` events (default: \"\")"""
    unmodifiedText: "NotRequired[str]"
    """Text that would have been generated by the keyboard if no modifiers were pressed (except for
shift). Useful for shortcut (accelerator) key handling (default: \"\")."""
    keyIdentifier: "NotRequired[str]"
    """Unique key identifier (e.g., 'U+0041') (default: \"\")."""
    code: "NotRequired[str]"
    """Unique DOM defined string value for each physical key (e.g., 'KeyA') (default: \"\")."""
    key: "NotRequired[str]"
    """Unique DOM defined string value describing the meaning of the key in the context of active
modifiers, keyboard layout, etc (e.g., 'AltGr') (default: \"\")."""
    windowsVirtualKeyCode: "NotRequired[int]"
    """Windows virtual key code (default: 0)."""
    nativeVirtualKeyCode: "NotRequired[int]"
    """Native virtual key code (default: 0)."""
    autoRepeat: "NotRequired[bool]"
    """Whether the event was generated from auto repeat (default: false)."""
    isKeypad: "NotRequired[bool]"
    """Whether the event was generated from the keypad (default: false)."""
    isSystemKey: "NotRequired[bool]"
    """Whether the event was a system key event (default: false)."""
    location: "NotRequired[int]"
    """Whether the event was from the left or right side of the keyboard. 1=Left, 2=Right (default:
0)."""
    commands: "NotRequired[List[str]]"
    """Editing commands to send with the key event (e.g., 'selectAll') (default: []).
These are related to but not equal the command names used in `document.execCommand` and NSStandardKeyBindingResponding.
See https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/editing/commands/editor_command_names.h for valid command names."""





class InsertTextParameters(TypedDict):
    text: "str"
    """The text to insert."""





class ImeSetCompositionParameters(TypedDict):
    text: "str"
    """The text to insert"""
    selectionStart: "int"
    """selection start"""
    selectionEnd: "int"
    """selection end"""
    replacementStart: "NotRequired[int]"
    """replacement start"""
    replacementEnd: "NotRequired[int]"
    """replacement end"""





class DispatchMouseEventParameters(TypedDict):
    type: "str"
    """Type of the mouse event."""
    x: "float"
    """X coordinate of the event relative to the main frame's viewport in CSS pixels."""
    y: "float"
    """Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
the top of the viewport and Y increases as it proceeds towards the bottom of the viewport."""
    modifiers: "NotRequired[int]"
    """Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
(default: 0)."""
    timestamp: "NotRequired[TimeSinceEpoch]"
    """Time at which the event occurred."""
    button: "NotRequired[MouseButton]"
    """Mouse button (default: \"none\")."""
    buttons: "NotRequired[int]"
    """A number indicating which buttons are pressed on the mouse when a mouse event is triggered.
Left=1, Right=2, Middle=4, Back=8, Forward=16, None=0."""
    clickCount: "NotRequired[int]"
    """Number of times the mouse button was clicked (default: 0)."""
    force: "NotRequired[float]"
    """The normalized pressure, which has a range of [0,1] (default: 0)."""
    tangentialPressure: "NotRequired[float]"
    """The normalized tangential pressure, which has a range of [-1,1] (default: 0)."""
    tiltX: "NotRequired[float]"
    """The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)."""
    tiltY: "NotRequired[float]"
    """The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0)."""
    twist: "NotRequired[int]"
    """The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0)."""
    deltaX: "NotRequired[float]"
    """X delta in CSS pixels for mouse wheel event (default: 0)."""
    deltaY: "NotRequired[float]"
    """Y delta in CSS pixels for mouse wheel event (default: 0)."""
    pointerType: "NotRequired[str]"
    """Pointer type (default: \"mouse\")."""





class DispatchTouchEventParameters(TypedDict):
    type: "str"
    """Type of the touch event. TouchEnd and TouchCancel must not contain any touch points, while
TouchStart and TouchMove must contains at least one."""
    touchPoints: "List[TouchPoint]"
    """Active touch points on the touch device. One event per any changed point (compared to
previous touch event in a sequence) is generated, emulating pressing/moving/releasing points
one by one."""
    modifiers: "NotRequired[int]"
    """Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
(default: 0)."""
    timestamp: "NotRequired[TimeSinceEpoch]"
    """Time at which the event occurred."""





class EmulateTouchFromMouseEventParameters(TypedDict):
    type: "str"
    """Type of the mouse event."""
    x: "int"
    """X coordinate of the mouse pointer in DIP."""
    y: "int"
    """Y coordinate of the mouse pointer in DIP."""
    button: "MouseButton"
    """Mouse button. Only \"none\", \"left\", \"right\" are supported."""
    timestamp: "NotRequired[TimeSinceEpoch]"
    """Time at which the event occurred (default: current time)."""
    deltaX: "NotRequired[float]"
    """X delta in DIP for mouse wheel event (default: 0)."""
    deltaY: "NotRequired[float]"
    """Y delta in DIP for mouse wheel event (default: 0)."""
    modifiers: "NotRequired[int]"
    """Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
(default: 0)."""
    clickCount: "NotRequired[int]"
    """Number of times the mouse button was clicked (default: 0)."""





class SetIgnoreInputEventsParameters(TypedDict):
    ignore: "bool"
    """Ignores input events processing when set to true."""





class SetInterceptDragsParameters(TypedDict):
    enabled: "bool"





class SynthesizePinchGestureParameters(TypedDict):
    x: "float"
    """X coordinate of the start of the gesture in CSS pixels."""
    y: "float"
    """Y coordinate of the start of the gesture in CSS pixels."""
    scaleFactor: "float"
    """Relative scale factor after zooming (>1.0 zooms in, <1.0 zooms out)."""
    relativeSpeed: "NotRequired[int]"
    """Relative pointer speed in pixels per second (default: 800)."""
    gestureSourceType: "NotRequired[GestureSourceType]"
    """Which type of input events to be generated (default: 'default', which queries the platform
for the preferred input type)."""





class SynthesizeScrollGestureParameters(TypedDict):
    x: "float"
    """X coordinate of the start of the gesture in CSS pixels."""
    y: "float"
    """Y coordinate of the start of the gesture in CSS pixels."""
    xDistance: "NotRequired[float]"
    """The distance to scroll along the X axis (positive to scroll left)."""
    yDistance: "NotRequired[float]"
    """The distance to scroll along the Y axis (positive to scroll up)."""
    xOverscroll: "NotRequired[float]"
    """The number of additional pixels to scroll back along the X axis, in addition to the given
distance."""
    yOverscroll: "NotRequired[float]"
    """The number of additional pixels to scroll back along the Y axis, in addition to the given
distance."""
    preventFling: "NotRequired[bool]"
    """Prevent fling (default: true)."""
    speed: "NotRequired[int]"
    """Swipe speed in pixels per second (default: 800)."""
    gestureSourceType: "NotRequired[GestureSourceType]"
    """Which type of input events to be generated (default: 'default', which queries the platform
for the preferred input type)."""
    repeatCount: "NotRequired[int]"
    """The number of times to repeat the gesture (default: 0)."""
    repeatDelayMs: "NotRequired[int]"
    """The number of milliseconds delay between each repeat. (default: 250)."""
    interactionMarkerName: "NotRequired[str]"
    """The name of the interaction markers to generate, if not empty (default: \"\")."""





class SynthesizeTapGestureParameters(TypedDict):
    x: "float"
    """X coordinate of the start of the gesture in CSS pixels."""
    y: "float"
    """Y coordinate of the start of the gesture in CSS pixels."""
    duration: "NotRequired[int]"
    """Duration between touchdown and touchup events in ms (default: 50)."""
    tapCount: "NotRequired[int]"
    """Number of times to perform the tap (e.g. 2 for double tap, default: 1)."""
    gestureSourceType: "NotRequired[GestureSourceType]"
    """Which type of input events to be generated (default: 'default', which queries the platform
for the preferred input type)."""


