# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Input Domain Types"""

from typing import List
from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

class TouchPoint(TypedDict):
    x: "float"
    """X coordinate of the event relative to the main frame's viewport in CSS pixels."""
    y: "float"
    """Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
the top of the viewport and Y increases as it proceeds towards the bottom of the viewport."""
    radiusX: "NotRequired[float]"
    """X radius of the touch area (default: 1.0)."""
    radiusY: "NotRequired[float]"
    """Y radius of the touch area (default: 1.0)."""
    rotationAngle: "NotRequired[float]"
    """Rotation angle (default: 0.0)."""
    force: "NotRequired[float]"
    """Force (default: 1.0)."""
    tangentialPressure: "NotRequired[float]"
    """The normalized tangential pressure, which has a range of [-1,1] (default: 0)."""
    tiltX: "NotRequired[float]"
    """The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)"""
    tiltY: "NotRequired[float]"
    """The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0)."""
    twist: "NotRequired[int]"
    """The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0)."""
    id: "NotRequired[float]"
    """Identifier used to track touch sources between events, must be unique within an event."""



GestureSourceType = Literal["default", "touch", "mouse"]



MouseButton = Literal["none", "left", "middle", "right", "back", "forward"]



TimeSinceEpoch = float
"""UTC time in seconds, counted from January 1, 1970."""



class DragDataItem(TypedDict):
    mimeType: "str"
    """Mime type of the dragged data."""
    data: "str"
    """Depending of the value of `mimeType`, it contains the dragged link,
text, HTML markup or any other data."""
    title: "NotRequired[str]"
    """Title associated with a link. Only valid when `mimeType` == \"text/uri-list\"."""
    baseURL: "NotRequired[str]"
    """Stores the base URL for the contained markup. Only valid when `mimeType`
== \"text/html\"."""



class DragData(TypedDict):
    items: "List[DragDataItem]"
    files: "NotRequired[List[str]]"
    """List of filenames that should be included when dropping"""
    dragOperationsMask: "int"
    """Bit field representing allowed drag operations. Copy = 1, Link = 2, Move = 16"""
