# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Inspector Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import DetachedEvent, TargetCrashedEvent, TargetReloadedAfterCrashEvent

class InspectorRegistration:
    """Event registration interface for Inspector domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Inspector"

    def detached(
        self,
        callback: Callable[['DetachedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for detached events.
        
        Fired when remote debugging connection is about to be terminated. Contains detach reason.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Inspector.detached", callback)

    def targetCrashed(
        self,
        callback: Callable[['TargetCrashedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for targetCrashed events.
        
        Fired when debugging target has crashed
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Inspector.targetCrashed", callback)

    def targetReloadedAfterCrash(
        self,
        callback: Callable[['TargetReloadedAfterCrashEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for targetReloadedAfterCrash events.
        
        Fired when debugging target has reloaded after crash
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Inspector.targetReloadedAfterCrash", callback)

