# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP IO Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import CloseParameters
    from .commands import ReadParameters
    from .commands import ReadReturns
    from .commands import ResolveBlobParameters
    from .commands import ResolveBlobReturns

class IOClient:
    """Client for IO domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def close(
        self,
        params: "CloseParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Close the stream, discard any temporary backing storage."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="IO.close",
            params=params,
            session_id=session_id,
        ))

    async def read(
        self,
        params: "ReadParameters",
        session_id: Optional[str] = None,
    ) -> "ReadReturns":
        """Read a chunk of the stream"""
        return cast("ReadReturns", await self._client.send_raw(
            method="IO.read",
            params=params,
            session_id=session_id,
        ))

    async def resolveBlob(
        self,
        params: "ResolveBlobParameters",
        session_id: Optional[str] = None,
    ) -> "ResolveBlobReturns":
        """Return UUID of Blob object specified by a remote object id."""
        return cast("ResolveBlobReturns", await self._client.send_raw(
            method="IO.resolveBlob",
            params=params,
            session_id=session_id,
        ))


