# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP LayerTree Domain Commands"""

from typing import Any, Dict, List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import Rect
    from .types import LayerId
    from .types import PaintProfile
    from .types import PictureTile
    from .types import SnapshotId

class CompositingReasonsParameters(TypedDict):
    layerId: "LayerId"
    """The id of the layer for which we want to get the reasons it was composited."""


class CompositingReasonsReturns(TypedDict):
    compositingReasons: "List[str]"
    """A list of strings specifying reasons for the given layer to become composited."""
    compositingReasonIds: "List[str]"
    """A list of strings specifying reason IDs for the given layer to become composited."""



class LoadSnapshotParameters(TypedDict):
    tiles: "List[PictureTile]"
    """An array of tiles composing the snapshot."""


class LoadSnapshotReturns(TypedDict):
    snapshotId: "SnapshotId"
    """The id of the snapshot."""



class MakeSnapshotParameters(TypedDict):
    layerId: "LayerId"
    """The id of the layer."""


class MakeSnapshotReturns(TypedDict):
    snapshotId: "SnapshotId"
    """The id of the layer snapshot."""



class ProfileSnapshotParameters(TypedDict):
    snapshotId: "SnapshotId"
    """The id of the layer snapshot."""
    minRepeatCount: "NotRequired[int]"
    """The maximum number of times to replay the snapshot (1, if not specified)."""
    minDuration: "NotRequired[float]"
    """The minimum duration (in seconds) to replay the snapshot."""
    clipRect: "NotRequired[Rect]"
    """The clip rectangle to apply when replaying the snapshot."""


class ProfileSnapshotReturns(TypedDict):
    timings: "List[PaintProfile]"
    """The array of paint profiles, one per run."""



class ReleaseSnapshotParameters(TypedDict):
    snapshotId: "SnapshotId"
    """The id of the layer snapshot."""





class ReplaySnapshotParameters(TypedDict):
    snapshotId: "SnapshotId"
    """The id of the layer snapshot."""
    fromStep: "NotRequired[int]"
    """The first step to replay from (replay from the very start if not specified)."""
    toStep: "NotRequired[int]"
    """The last step to replay to (replay till the end if not specified)."""
    scale: "NotRequired[float]"
    """The scale to apply while replaying (defaults to 1)."""


class ReplaySnapshotReturns(TypedDict):
    dataURL: "str"
    """A data: URL for resulting image."""



class SnapshotCommandLogParameters(TypedDict):
    snapshotId: "SnapshotId"
    """The id of the layer snapshot."""


class SnapshotCommandLogReturns(TypedDict):
    commandLog: "List[Dict[str, Any]]"
    """The array of canvas function calls."""
