# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Log Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import StartViolationsReportParameters

class LogClient:
    """Client for Log domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def clear(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears the log."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Log.clear",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables log domain, prevents further log entries from being reported to the client."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Log.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables log domain, sends the entries collected so far to the client by means of the
`entryAdded` notification."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Log.enable",
            params=params,
            session_id=session_id,
        ))

    async def startViolationsReport(
        self,
        params: "StartViolationsReportParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """start violation reporting."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Log.startViolationsReport",
            params=params,
            session_id=session_id,
        ))

    async def stopViolationsReport(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Stop violation reporting."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Log.stopViolationsReport",
            params=params,
            session_id=session_id,
        ))


