# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Media Domain Types"""

from typing import Any, Dict, List
from typing_extensions import TypedDict

PlayerId = str
"""Players will get an ID that is unique within the agent context."""



Timestamp = float



class PlayerMessage(TypedDict):
    """Have one type per entry in MediaLogRecord::Type
Corresponds to kMessage"""

    level: "str"
    """Keep in sync with MediaLogMessageLevel
We are currently keeping the message level 'error' separate from the
PlayerError type because right now they represent different things,
this one being a DVLOG(ERROR) style log message that gets printed
based on what log level is selected in the UI, and the other is a
representation of a media::PipelineStatus object. Soon however we're
going to be moving away from using PipelineStatus for errors and
introducing a new error type which should hopefully let us integrate
the error log level into the PlayerError type."""
    message: "str"



class PlayerProperty(TypedDict):
    """Corresponds to kMediaPropertyChange"""

    name: "str"
    value: "str"



class PlayerEvent(TypedDict):
    """Corresponds to kMediaEventTriggered"""

    timestamp: "Timestamp"
    value: "str"



class PlayerErrorSourceLocation(TypedDict):
    """Represents logged source line numbers reported in an error.
NOTE: file and line are from chromium c++ implementation code, not js."""

    file: "str"
    line: "int"



class PlayerError(TypedDict):
    """Corresponds to kMediaError"""

    errorType: "str"
    code: "int"
    """Code is the numeric enum entry for a specific set of error codes, such
as PipelineStatusCodes in media/base/pipeline_status.h"""
    stack: "List[PlayerErrorSourceLocation]"
    """A trace of where this error was caused / where it passed through."""
    cause: "List[PlayerError]"
    """Errors potentially have a root cause error, ie, a DecoderError might be
caused by an WindowsError"""
    data: "Dict[str, Any]"
    """Extra data attached to an error, such as an HRESULT, Video Codec, etc."""
