# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Network Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import CanClearBrowserCacheReturns
    from .commands import CanClearBrowserCookiesReturns
    from .commands import CanEmulateNetworkConditionsReturns
    from .commands import ContinueInterceptedRequestParameters
    from .commands import DeleteCookiesParameters
    from .commands import EmulateNetworkConditionsParameters
    from .commands import EnableParameters
    from .commands import EnableReportingApiParameters
    from .commands import GetAllCookiesReturns
    from .commands import GetCertificateParameters
    from .commands import GetCertificateReturns
    from .commands import GetCookiesParameters
    from .commands import GetCookiesReturns
    from .commands import GetRequestPostDataParameters
    from .commands import GetRequestPostDataReturns
    from .commands import GetResponseBodyForInterceptionParameters
    from .commands import GetResponseBodyForInterceptionReturns
    from .commands import GetResponseBodyParameters
    from .commands import GetResponseBodyReturns
    from .commands import GetSecurityIsolationStatusParameters
    from .commands import GetSecurityIsolationStatusReturns
    from .commands import LoadNetworkResourceParameters
    from .commands import LoadNetworkResourceReturns
    from .commands import ReplayXHRParameters
    from .commands import SearchInResponseBodyParameters
    from .commands import SearchInResponseBodyReturns
    from .commands import SetAcceptedEncodingsParameters
    from .commands import SetAttachDebugStackParameters
    from .commands import SetBlockedURLsParameters
    from .commands import SetBypassServiceWorkerParameters
    from .commands import SetCacheDisabledParameters
    from .commands import SetCookieControlsParameters
    from .commands import SetCookieParameters
    from .commands import SetCookieReturns
    from .commands import SetCookiesParameters
    from .commands import SetExtraHTTPHeadersParameters
    from .commands import SetRequestInterceptionParameters
    from .commands import SetUserAgentOverrideParameters
    from .commands import StreamResourceContentParameters
    from .commands import StreamResourceContentReturns
    from .commands import TakeResponseBodyForInterceptionAsStreamParameters
    from .commands import TakeResponseBodyForInterceptionAsStreamReturns

class NetworkClient:
    """Client for Network domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def setAcceptedEncodings(
        self,
        params: "SetAcceptedEncodingsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets a list of content encodings that will be accepted. Empty list means no encoding is accepted."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setAcceptedEncodings",
            params=params,
            session_id=session_id,
        ))

    async def clearAcceptedEncodingsOverride(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears accepted encodings set by setAcceptedEncodings"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.clearAcceptedEncodingsOverride",
            params=params,
            session_id=session_id,
        ))

    async def canClearBrowserCache(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "CanClearBrowserCacheReturns":
        """Tells whether clearing browser cache is supported."""
        return cast("CanClearBrowserCacheReturns", await self._client.send_raw(
            method="Network.canClearBrowserCache",
            params=params,
            session_id=session_id,
        ))

    async def canClearBrowserCookies(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "CanClearBrowserCookiesReturns":
        """Tells whether clearing browser cookies is supported."""
        return cast("CanClearBrowserCookiesReturns", await self._client.send_raw(
            method="Network.canClearBrowserCookies",
            params=params,
            session_id=session_id,
        ))

    async def canEmulateNetworkConditions(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "CanEmulateNetworkConditionsReturns":
        """Tells whether emulation of network conditions is supported."""
        return cast("CanEmulateNetworkConditionsReturns", await self._client.send_raw(
            method="Network.canEmulateNetworkConditions",
            params=params,
            session_id=session_id,
        ))

    async def clearBrowserCache(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears browser cache."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.clearBrowserCache",
            params=params,
            session_id=session_id,
        ))

    async def clearBrowserCookies(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears browser cookies."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.clearBrowserCookies",
            params=params,
            session_id=session_id,
        ))

    async def continueInterceptedRequest(
        self,
        params: "ContinueInterceptedRequestParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Response to Network.requestIntercepted which either modifies the request to continue with any
modifications, or blocks it, or completes it with the provided response bytes. If a network
fetch occurs as a result which encounters a redirect an additional Network.requestIntercepted
event will be sent with the same InterceptionId.
Deprecated, use Fetch.continueRequest, Fetch.fulfillRequest and Fetch.failRequest instead."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.continueInterceptedRequest",
            params=params,
            session_id=session_id,
        ))

    async def deleteCookies(
        self,
        params: "DeleteCookiesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deletes browser cookies with matching name and url or domain/path/partitionKey pair."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.deleteCookies",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables network tracking, prevents network events from being sent to the client."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.disable",
            params=params,
            session_id=session_id,
        ))

    async def emulateNetworkConditions(
        self,
        params: "EmulateNetworkConditionsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Activates emulation of network conditions."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.emulateNetworkConditions",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: Optional["EnableParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables network tracking, network events will now be delivered to the client."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.enable",
            params=params,
            session_id=session_id,
        ))

    async def getAllCookies(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetAllCookiesReturns":
        """Returns all browser cookies. Depending on the backend support, will return detailed cookie
information in the `cookies` field.
Deprecated. Use Storage.getCookies instead."""
        return cast("GetAllCookiesReturns", await self._client.send_raw(
            method="Network.getAllCookies",
            params=params,
            session_id=session_id,
        ))

    async def getCertificate(
        self,
        params: "GetCertificateParameters",
        session_id: Optional[str] = None,
    ) -> "GetCertificateReturns":
        """Returns the DER-encoded certificate."""
        return cast("GetCertificateReturns", await self._client.send_raw(
            method="Network.getCertificate",
            params=params,
            session_id=session_id,
        ))

    async def getCookies(
        self,
        params: Optional["GetCookiesParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetCookiesReturns":
        """Returns all browser cookies for the current URL. Depending on the backend support, will return
detailed cookie information in the `cookies` field."""
        return cast("GetCookiesReturns", await self._client.send_raw(
            method="Network.getCookies",
            params=params,
            session_id=session_id,
        ))

    async def getResponseBody(
        self,
        params: "GetResponseBodyParameters",
        session_id: Optional[str] = None,
    ) -> "GetResponseBodyReturns":
        """Returns content served for the given request."""
        return cast("GetResponseBodyReturns", await self._client.send_raw(
            method="Network.getResponseBody",
            params=params,
            session_id=session_id,
        ))

    async def getRequestPostData(
        self,
        params: "GetRequestPostDataParameters",
        session_id: Optional[str] = None,
    ) -> "GetRequestPostDataReturns":
        """Returns post data sent with the request. Returns an error when no data was sent with the request."""
        return cast("GetRequestPostDataReturns", await self._client.send_raw(
            method="Network.getRequestPostData",
            params=params,
            session_id=session_id,
        ))

    async def getResponseBodyForInterception(
        self,
        params: "GetResponseBodyForInterceptionParameters",
        session_id: Optional[str] = None,
    ) -> "GetResponseBodyForInterceptionReturns":
        """Returns content served for the given currently intercepted request."""
        return cast("GetResponseBodyForInterceptionReturns", await self._client.send_raw(
            method="Network.getResponseBodyForInterception",
            params=params,
            session_id=session_id,
        ))

    async def takeResponseBodyForInterceptionAsStream(
        self,
        params: "TakeResponseBodyForInterceptionAsStreamParameters",
        session_id: Optional[str] = None,
    ) -> "TakeResponseBodyForInterceptionAsStreamReturns":
        """Returns a handle to the stream representing the response body. Note that after this command,
the intercepted request can't be continued as is -- you either need to cancel it or to provide
the response body. The stream only supports sequential read, IO.read will fail if the position
is specified."""
        return cast("TakeResponseBodyForInterceptionAsStreamReturns", await self._client.send_raw(
            method="Network.takeResponseBodyForInterceptionAsStream",
            params=params,
            session_id=session_id,
        ))

    async def replayXHR(
        self,
        params: "ReplayXHRParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """This method sends a new XMLHttpRequest which is identical to the original one. The following
parameters should be identical: method, url, async, request body, extra headers, withCredentials
attribute, user, password."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.replayXHR",
            params=params,
            session_id=session_id,
        ))

    async def searchInResponseBody(
        self,
        params: "SearchInResponseBodyParameters",
        session_id: Optional[str] = None,
    ) -> "SearchInResponseBodyReturns":
        """Searches for given string in response content."""
        return cast("SearchInResponseBodyReturns", await self._client.send_raw(
            method="Network.searchInResponseBody",
            params=params,
            session_id=session_id,
        ))

    async def setBlockedURLs(
        self,
        params: "SetBlockedURLsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Blocks URLs from loading."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setBlockedURLs",
            params=params,
            session_id=session_id,
        ))

    async def setBypassServiceWorker(
        self,
        params: "SetBypassServiceWorkerParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Toggles ignoring of service worker for each request."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setBypassServiceWorker",
            params=params,
            session_id=session_id,
        ))

    async def setCacheDisabled(
        self,
        params: "SetCacheDisabledParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Toggles ignoring cache for each request. If `true`, cache will not be used."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setCacheDisabled",
            params=params,
            session_id=session_id,
        ))

    async def setCookie(
        self,
        params: "SetCookieParameters",
        session_id: Optional[str] = None,
    ) -> "SetCookieReturns":
        """Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist."""
        return cast("SetCookieReturns", await self._client.send_raw(
            method="Network.setCookie",
            params=params,
            session_id=session_id,
        ))

    async def setCookies(
        self,
        params: "SetCookiesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets given cookies."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setCookies",
            params=params,
            session_id=session_id,
        ))

    async def setExtraHTTPHeaders(
        self,
        params: "SetExtraHTTPHeadersParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Specifies whether to always send extra HTTP headers with the requests from this page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setExtraHTTPHeaders",
            params=params,
            session_id=session_id,
        ))

    async def setAttachDebugStack(
        self,
        params: "SetAttachDebugStackParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Specifies whether to attach a page script stack id in requests"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setAttachDebugStack",
            params=params,
            session_id=session_id,
        ))

    async def setRequestInterception(
        self,
        params: "SetRequestInterceptionParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets the requests to intercept that match the provided patterns and optionally resource types.
Deprecated, please use Fetch.enable instead."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setRequestInterception",
            params=params,
            session_id=session_id,
        ))

    async def setUserAgentOverride(
        self,
        params: "SetUserAgentOverrideParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Allows overriding user agent with the given string."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setUserAgentOverride",
            params=params,
            session_id=session_id,
        ))

    async def streamResourceContent(
        self,
        params: "StreamResourceContentParameters",
        session_id: Optional[str] = None,
    ) -> "StreamResourceContentReturns":
        """Enables streaming of the response for the given requestId.
If enabled, the dataReceived event contains the data that was received during streaming."""
        return cast("StreamResourceContentReturns", await self._client.send_raw(
            method="Network.streamResourceContent",
            params=params,
            session_id=session_id,
        ))

    async def getSecurityIsolationStatus(
        self,
        params: Optional["GetSecurityIsolationStatusParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetSecurityIsolationStatusReturns":
        """Returns information about the COEP/COOP isolation status."""
        return cast("GetSecurityIsolationStatusReturns", await self._client.send_raw(
            method="Network.getSecurityIsolationStatus",
            params=params,
            session_id=session_id,
        ))

    async def enableReportingApi(
        self,
        params: "EnableReportingApiParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables tracking for the Reporting API, events generated by the Reporting API will now be delivered to the client.
Enabling triggers 'reportingApiReportAdded' for all existing reports."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.enableReportingApi",
            params=params,
            session_id=session_id,
        ))

    async def loadNetworkResource(
        self,
        params: "LoadNetworkResourceParameters",
        session_id: Optional[str] = None,
    ) -> "LoadNetworkResourceReturns":
        """Fetches the resource and returns the content."""
        return cast("LoadNetworkResourceReturns", await self._client.send_raw(
            method="Network.loadNetworkResource",
            params=params,
            session_id=session_id,
        ))

    async def setCookieControls(
        self,
        params: "SetCookieControlsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets Controls for third-party cookie access
Page reload is required before the new cookie behavior will be observed"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Network.setCookieControls",
            params=params,
            session_id=session_id,
        ))


