# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Page Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import AddCompilationCacheParameters
    from .commands import AddScriptToEvaluateOnLoadParameters
    from .commands import AddScriptToEvaluateOnLoadReturns
    from .commands import AddScriptToEvaluateOnNewDocumentParameters
    from .commands import AddScriptToEvaluateOnNewDocumentReturns
    from .commands import CaptureScreenshotParameters
    from .commands import CaptureScreenshotReturns
    from .commands import CaptureSnapshotParameters
    from .commands import CaptureSnapshotReturns
    from .commands import CreateIsolatedWorldParameters
    from .commands import CreateIsolatedWorldReturns
    from .commands import DeleteCookieParameters
    from .commands import EnableParameters
    from .commands import GenerateTestReportParameters
    from .commands import GetAdScriptAncestryParameters
    from .commands import GetAdScriptAncestryReturns
    from .commands import GetAppIdReturns
    from .commands import GetAppManifestParameters
    from .commands import GetAppManifestReturns
    from .commands import GetFrameTreeReturns
    from .commands import GetInstallabilityErrorsReturns
    from .commands import GetLayoutMetricsReturns
    from .commands import GetManifestIconsReturns
    from .commands import GetNavigationHistoryReturns
    from .commands import GetOriginTrialsParameters
    from .commands import GetOriginTrialsReturns
    from .commands import GetPermissionsPolicyStateParameters
    from .commands import GetPermissionsPolicyStateReturns
    from .commands import GetResourceContentParameters
    from .commands import GetResourceContentReturns
    from .commands import GetResourceTreeReturns
    from .commands import HandleJavaScriptDialogParameters
    from .commands import NavigateParameters
    from .commands import NavigateReturns
    from .commands import NavigateToHistoryEntryParameters
    from .commands import PrintToPDFParameters
    from .commands import PrintToPDFReturns
    from .commands import ProduceCompilationCacheParameters
    from .commands import ReloadParameters
    from .commands import RemoveScriptToEvaluateOnLoadParameters
    from .commands import RemoveScriptToEvaluateOnNewDocumentParameters
    from .commands import ScreencastFrameAckParameters
    from .commands import SearchInResourceParameters
    from .commands import SearchInResourceReturns
    from .commands import SetAdBlockingEnabledParameters
    from .commands import SetBypassCSPParameters
    from .commands import SetDeviceMetricsOverrideParameters
    from .commands import SetDeviceOrientationOverrideParameters
    from .commands import SetDocumentContentParameters
    from .commands import SetDownloadBehaviorParameters
    from .commands import SetFontFamiliesParameters
    from .commands import SetFontSizesParameters
    from .commands import SetGeolocationOverrideParameters
    from .commands import SetInterceptFileChooserDialogParameters
    from .commands import SetLifecycleEventsEnabledParameters
    from .commands import SetPrerenderingAllowedParameters
    from .commands import SetRPHRegistrationModeParameters
    from .commands import SetSPCTransactionModeParameters
    from .commands import SetTouchEmulationEnabledParameters
    from .commands import SetWebLifecycleStateParameters
    from .commands import StartScreencastParameters

class PageClient:
    """Client for Page domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def addScriptToEvaluateOnLoad(
        self,
        params: "AddScriptToEvaluateOnLoadParameters",
        session_id: Optional[str] = None,
    ) -> "AddScriptToEvaluateOnLoadReturns":
        """Deprecated, please use addScriptToEvaluateOnNewDocument instead."""
        return cast("AddScriptToEvaluateOnLoadReturns", await self._client.send_raw(
            method="Page.addScriptToEvaluateOnLoad",
            params=params,
            session_id=session_id,
        ))

    async def addScriptToEvaluateOnNewDocument(
        self,
        params: "AddScriptToEvaluateOnNewDocumentParameters",
        session_id: Optional[str] = None,
    ) -> "AddScriptToEvaluateOnNewDocumentReturns":
        """Evaluates given script in every frame upon creation (before loading frame's scripts)."""
        return cast("AddScriptToEvaluateOnNewDocumentReturns", await self._client.send_raw(
            method="Page.addScriptToEvaluateOnNewDocument",
            params=params,
            session_id=session_id,
        ))

    async def bringToFront(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Brings page to front (activates tab)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.bringToFront",
            params=params,
            session_id=session_id,
        ))

    async def captureScreenshot(
        self,
        params: Optional["CaptureScreenshotParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "CaptureScreenshotReturns":
        """Capture page screenshot."""
        return cast("CaptureScreenshotReturns", await self._client.send_raw(
            method="Page.captureScreenshot",
            params=params,
            session_id=session_id,
        ))

    async def captureSnapshot(
        self,
        params: Optional["CaptureSnapshotParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "CaptureSnapshotReturns":
        """Returns a snapshot of the page as a string. For MHTML format, the serialization includes
iframes, shadow DOM, external resources, and element-inline styles."""
        return cast("CaptureSnapshotReturns", await self._client.send_raw(
            method="Page.captureSnapshot",
            params=params,
            session_id=session_id,
        ))

    async def clearDeviceMetricsOverride(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears the overridden device metrics."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.clearDeviceMetricsOverride",
            params=params,
            session_id=session_id,
        ))

    async def clearDeviceOrientationOverride(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears the overridden Device Orientation."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.clearDeviceOrientationOverride",
            params=params,
            session_id=session_id,
        ))

    async def clearGeolocationOverride(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears the overridden Geolocation Position and Error."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.clearGeolocationOverride",
            params=params,
            session_id=session_id,
        ))

    async def createIsolatedWorld(
        self,
        params: "CreateIsolatedWorldParameters",
        session_id: Optional[str] = None,
    ) -> "CreateIsolatedWorldReturns":
        """Creates an isolated world for the given frame."""
        return cast("CreateIsolatedWorldReturns", await self._client.send_raw(
            method="Page.createIsolatedWorld",
            params=params,
            session_id=session_id,
        ))

    async def deleteCookie(
        self,
        params: "DeleteCookieParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deletes browser cookie with given name, domain and path."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.deleteCookie",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables page domain notifications."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: Optional["EnableParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables page domain notifications."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.enable",
            params=params,
            session_id=session_id,
        ))

    async def getAppManifest(
        self,
        params: Optional["GetAppManifestParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetAppManifestReturns":
        """Gets the processed manifest for this current document.
  This API always waits for the manifest to be loaded.
  If manifestId is provided, and it does not match the manifest of the
    current document, this API errors out.
  If there is not a loaded page, this API errors out immediately."""
        return cast("GetAppManifestReturns", await self._client.send_raw(
            method="Page.getAppManifest",
            params=params,
            session_id=session_id,
        ))

    async def getInstallabilityErrors(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetInstallabilityErrorsReturns":
        return cast("GetInstallabilityErrorsReturns", await self._client.send_raw(
            method="Page.getInstallabilityErrors",
            params=params,
            session_id=session_id,
        ))

    async def getManifestIcons(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetManifestIconsReturns":
        """Deprecated because it's not guaranteed that the returned icon is in fact the one used for PWA installation."""
        return cast("GetManifestIconsReturns", await self._client.send_raw(
            method="Page.getManifestIcons",
            params=params,
            session_id=session_id,
        ))

    async def getAppId(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetAppIdReturns":
        """Returns the unique (PWA) app id.
Only returns values if the feature flag 'WebAppEnableManifestId' is enabled"""
        return cast("GetAppIdReturns", await self._client.send_raw(
            method="Page.getAppId",
            params=params,
            session_id=session_id,
        ))

    async def getAdScriptAncestry(
        self,
        params: "GetAdScriptAncestryParameters",
        session_id: Optional[str] = None,
    ) -> "GetAdScriptAncestryReturns":
        return cast("GetAdScriptAncestryReturns", await self._client.send_raw(
            method="Page.getAdScriptAncestry",
            params=params,
            session_id=session_id,
        ))

    async def getFrameTree(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetFrameTreeReturns":
        """Returns present frame tree structure."""
        return cast("GetFrameTreeReturns", await self._client.send_raw(
            method="Page.getFrameTree",
            params=params,
            session_id=session_id,
        ))

    async def getLayoutMetrics(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetLayoutMetricsReturns":
        """Returns metrics relating to the layouting of the page, such as viewport bounds/scale."""
        return cast("GetLayoutMetricsReturns", await self._client.send_raw(
            method="Page.getLayoutMetrics",
            params=params,
            session_id=session_id,
        ))

    async def getNavigationHistory(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetNavigationHistoryReturns":
        """Returns navigation history for the current page."""
        return cast("GetNavigationHistoryReturns", await self._client.send_raw(
            method="Page.getNavigationHistory",
            params=params,
            session_id=session_id,
        ))

    async def resetNavigationHistory(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Resets navigation history for the current page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.resetNavigationHistory",
            params=params,
            session_id=session_id,
        ))

    async def getResourceContent(
        self,
        params: "GetResourceContentParameters",
        session_id: Optional[str] = None,
    ) -> "GetResourceContentReturns":
        """Returns content of the given resource."""
        return cast("GetResourceContentReturns", await self._client.send_raw(
            method="Page.getResourceContent",
            params=params,
            session_id=session_id,
        ))

    async def getResourceTree(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetResourceTreeReturns":
        """Returns present frame / resource tree structure."""
        return cast("GetResourceTreeReturns", await self._client.send_raw(
            method="Page.getResourceTree",
            params=params,
            session_id=session_id,
        ))

    async def handleJavaScriptDialog(
        self,
        params: "HandleJavaScriptDialogParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Accepts or dismisses a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.handleJavaScriptDialog",
            params=params,
            session_id=session_id,
        ))

    async def navigate(
        self,
        params: "NavigateParameters",
        session_id: Optional[str] = None,
    ) -> "NavigateReturns":
        """Navigates current page to the given URL."""
        return cast("NavigateReturns", await self._client.send_raw(
            method="Page.navigate",
            params=params,
            session_id=session_id,
        ))

    async def navigateToHistoryEntry(
        self,
        params: "NavigateToHistoryEntryParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Navigates current page to the given history entry."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.navigateToHistoryEntry",
            params=params,
            session_id=session_id,
        ))

    async def printToPDF(
        self,
        params: Optional["PrintToPDFParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "PrintToPDFReturns":
        """Print page as PDF."""
        return cast("PrintToPDFReturns", await self._client.send_raw(
            method="Page.printToPDF",
            params=params,
            session_id=session_id,
        ))

    async def reload(
        self,
        params: Optional["ReloadParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Reloads given page optionally ignoring the cache."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.reload",
            params=params,
            session_id=session_id,
        ))

    async def removeScriptToEvaluateOnLoad(
        self,
        params: "RemoveScriptToEvaluateOnLoadParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deprecated, please use removeScriptToEvaluateOnNewDocument instead."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.removeScriptToEvaluateOnLoad",
            params=params,
            session_id=session_id,
        ))

    async def removeScriptToEvaluateOnNewDocument(
        self,
        params: "RemoveScriptToEvaluateOnNewDocumentParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes given script from the list."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.removeScriptToEvaluateOnNewDocument",
            params=params,
            session_id=session_id,
        ))

    async def screencastFrameAck(
        self,
        params: "ScreencastFrameAckParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Acknowledges that a screencast frame has been received by the frontend."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.screencastFrameAck",
            params=params,
            session_id=session_id,
        ))

    async def searchInResource(
        self,
        params: "SearchInResourceParameters",
        session_id: Optional[str] = None,
    ) -> "SearchInResourceReturns":
        """Searches for given string in resource content."""
        return cast("SearchInResourceReturns", await self._client.send_raw(
            method="Page.searchInResource",
            params=params,
            session_id=session_id,
        ))

    async def setAdBlockingEnabled(
        self,
        params: "SetAdBlockingEnabledParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enable Chrome's experimental ad filter on all sites."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setAdBlockingEnabled",
            params=params,
            session_id=session_id,
        ))

    async def setBypassCSP(
        self,
        params: "SetBypassCSPParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enable page Content Security Policy by-passing."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setBypassCSP",
            params=params,
            session_id=session_id,
        ))

    async def getPermissionsPolicyState(
        self,
        params: "GetPermissionsPolicyStateParameters",
        session_id: Optional[str] = None,
    ) -> "GetPermissionsPolicyStateReturns":
        """Get Permissions Policy state on given frame."""
        return cast("GetPermissionsPolicyStateReturns", await self._client.send_raw(
            method="Page.getPermissionsPolicyState",
            params=params,
            session_id=session_id,
        ))

    async def getOriginTrials(
        self,
        params: "GetOriginTrialsParameters",
        session_id: Optional[str] = None,
    ) -> "GetOriginTrialsReturns":
        """Get Origin Trials on given frame."""
        return cast("GetOriginTrialsReturns", await self._client.send_raw(
            method="Page.getOriginTrials",
            params=params,
            session_id=session_id,
        ))

    async def setDeviceMetricsOverride(
        self,
        params: "SetDeviceMetricsOverrideParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
window.innerWidth, window.innerHeight, and \"device-width\"/\"device-height\"-related CSS media
query results)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setDeviceMetricsOverride",
            params=params,
            session_id=session_id,
        ))

    async def setDeviceOrientationOverride(
        self,
        params: "SetDeviceOrientationOverrideParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Overrides the Device Orientation."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setDeviceOrientationOverride",
            params=params,
            session_id=session_id,
        ))

    async def setFontFamilies(
        self,
        params: "SetFontFamiliesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set generic font families."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setFontFamilies",
            params=params,
            session_id=session_id,
        ))

    async def setFontSizes(
        self,
        params: "SetFontSizesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set default font sizes."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setFontSizes",
            params=params,
            session_id=session_id,
        ))

    async def setDocumentContent(
        self,
        params: "SetDocumentContentParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets given markup as the document's HTML."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setDocumentContent",
            params=params,
            session_id=session_id,
        ))

    async def setDownloadBehavior(
        self,
        params: "SetDownloadBehaviorParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set the behavior when downloading a file."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setDownloadBehavior",
            params=params,
            session_id=session_id,
        ))

    async def setGeolocationOverride(
        self,
        params: Optional["SetGeolocationOverrideParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position
unavailable."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setGeolocationOverride",
            params=params,
            session_id=session_id,
        ))

    async def setLifecycleEventsEnabled(
        self,
        params: "SetLifecycleEventsEnabledParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Controls whether page will emit lifecycle events."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setLifecycleEventsEnabled",
            params=params,
            session_id=session_id,
        ))

    async def setTouchEmulationEnabled(
        self,
        params: "SetTouchEmulationEnabledParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Toggles mouse event-based touch event emulation."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setTouchEmulationEnabled",
            params=params,
            session_id=session_id,
        ))

    async def startScreencast(
        self,
        params: Optional["StartScreencastParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Starts sending each frame using the `screencastFrame` event."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.startScreencast",
            params=params,
            session_id=session_id,
        ))

    async def stopLoading(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Force the page stop all navigations and pending resource fetches."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.stopLoading",
            params=params,
            session_id=session_id,
        ))

    async def crash(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Crashes renderer on the IO thread, generates minidumps."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.crash",
            params=params,
            session_id=session_id,
        ))

    async def close(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Tries to close page, running its beforeunload hooks, if any."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.close",
            params=params,
            session_id=session_id,
        ))

    async def setWebLifecycleState(
        self,
        params: "SetWebLifecycleStateParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Tries to update the web lifecycle state of the page.
It will transition the page to the given state according to:
https://github.com/WICG/web-lifecycle/"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setWebLifecycleState",
            params=params,
            session_id=session_id,
        ))

    async def stopScreencast(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Stops sending each frame in the `screencastFrame`."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.stopScreencast",
            params=params,
            session_id=session_id,
        ))

    async def produceCompilationCache(
        self,
        params: "ProduceCompilationCacheParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Requests backend to produce compilation cache for the specified scripts.
`scripts` are appended to the list of scripts for which the cache
would be produced. The list may be reset during page navigation.
When script with a matching URL is encountered, the cache is optionally
produced upon backend discretion, based on internal heuristics.
See also: `Page.compilationCacheProduced`."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.produceCompilationCache",
            params=params,
            session_id=session_id,
        ))

    async def addCompilationCache(
        self,
        params: "AddCompilationCacheParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Seeds compilation cache for given url. Compilation cache does not survive
cross-process navigation."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.addCompilationCache",
            params=params,
            session_id=session_id,
        ))

    async def clearCompilationCache(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears seeded compilation cache."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.clearCompilationCache",
            params=params,
            session_id=session_id,
        ))

    async def setSPCTransactionMode(
        self,
        params: "SetSPCTransactionModeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets the Secure Payment Confirmation transaction mode.
https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setSPCTransactionMode",
            params=params,
            session_id=session_id,
        ))

    async def setRPHRegistrationMode(
        self,
        params: "SetRPHRegistrationModeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Extensions for Custom Handlers API:
https://html.spec.whatwg.org/multipage/system-state.html#rph-automation"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setRPHRegistrationMode",
            params=params,
            session_id=session_id,
        ))

    async def generateTestReport(
        self,
        params: "GenerateTestReportParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Generates a report for testing."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.generateTestReport",
            params=params,
            session_id=session_id,
        ))

    async def waitForDebugger(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Pauses page execution. Can be resumed using generic Runtime.runIfWaitingForDebugger."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.waitForDebugger",
            params=params,
            session_id=session_id,
        ))

    async def setInterceptFileChooserDialog(
        self,
        params: "SetInterceptFileChooserDialogParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Intercept file chooser requests and transfer control to protocol clients.
When file chooser interception is enabled, native file chooser dialog is not shown.
Instead, a protocol event `Page.fileChooserOpened` is emitted."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setInterceptFileChooserDialog",
            params=params,
            session_id=session_id,
        ))

    async def setPrerenderingAllowed(
        self,
        params: "SetPrerenderingAllowedParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enable/disable prerendering manually.

This command is a short-term solution for https://crbug.com/1440085.
See https://docs.google.com/document/d/12HVmFxYj5Jc-eJr5OmWsa2bqTJsbgGLKI6ZIyx0_wpA
for more details.

TODO(https://crbug.com/1440085): Remove this once Puppeteer supports tab targets."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Page.setPrerenderingAllowed",
            params=params,
            session_id=session_id,
        ))


