# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Preload Domain Events"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..network.types import LoaderId
    from ..network.types import RequestId
    from ..page.types import FrameId
    from .types import PrefetchStatus
    from .types import PreloadPipelineId
    from .types import PreloadingAttemptKey
    from .types import PreloadingAttemptSource
    from .types import PreloadingStatus
    from .types import PrerenderFinalStatus
    from .types import PrerenderMismatchedHeaders
    from .types import RuleSet
    from .types import RuleSetId

"""Upsert. Currently, it is only emitted when a rule set added."""
class RuleSetUpdatedEvent(TypedDict):
    ruleSet: "RuleSet"



class RuleSetRemovedEvent(TypedDict):
    id: "RuleSetId"



"""Fired when a preload enabled state is updated."""
class PreloadEnabledStateUpdatedEvent(TypedDict):
    disabledByPreference: "bool"
    disabledByDataSaver: "bool"
    disabledByBatterySaver: "bool"
    disabledByHoldbackPrefetchSpeculationRules: "bool"
    disabledByHoldbackPrerenderSpeculationRules: "bool"



"""Fired when a prefetch attempt is updated."""
class PrefetchStatusUpdatedEvent(TypedDict):
    key: "PreloadingAttemptKey"
    pipelineId: "PreloadPipelineId"
    initiatingFrameId: "FrameId"
    """The frame id of the frame initiating prefetch."""
    prefetchUrl: "str"
    status: "PreloadingStatus"
    prefetchStatus: "PrefetchStatus"
    requestId: "RequestId"



"""Fired when a prerender attempt is updated."""
class PrerenderStatusUpdatedEvent(TypedDict):
    key: "PreloadingAttemptKey"
    pipelineId: "PreloadPipelineId"
    status: "PreloadingStatus"
    prerenderStatus: "NotRequired[PrerenderFinalStatus]"
    disallowedMojoInterface: "NotRequired[str]"
    """This is used to give users more information about the name of Mojo interface
that is incompatible with prerender and has caused the cancellation of the attempt."""
    mismatchedHeaders: "NotRequired[List[PrerenderMismatchedHeaders]]"



"""Send a list of sources for all preloading attempts in a document."""
class PreloadingAttemptSourcesUpdatedEvent(TypedDict):
    loaderId: "LoaderId"
    preloadingAttemptSources: "List[PreloadingAttemptSource]"
