# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Preload Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import (
    PrefetchStatusUpdatedEvent,
    PreloadEnabledStateUpdatedEvent,
    PreloadingAttemptSourcesUpdatedEvent,
    PrerenderStatusUpdatedEvent,
    RuleSetRemovedEvent,
    RuleSetUpdatedEvent
)

class PreloadRegistration:
    """Event registration interface for Preload domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Preload"

    def ruleSetUpdated(
        self,
        callback: Callable[['RuleSetUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for ruleSetUpdated events.
        
        Upsert. Currently, it is only emitted when a rule set added.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Preload.ruleSetUpdated", callback)

    def ruleSetRemoved(
        self,
        callback: Callable[['RuleSetRemovedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for ruleSetRemoved events.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Preload.ruleSetRemoved", callback)

    def preloadEnabledStateUpdated(
        self,
        callback: Callable[['PreloadEnabledStateUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for preloadEnabledStateUpdated events.
        
        Fired when a preload enabled state is updated.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Preload.preloadEnabledStateUpdated", callback)

    def prefetchStatusUpdated(
        self,
        callback: Callable[['PrefetchStatusUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for prefetchStatusUpdated events.
        
        Fired when a prefetch attempt is updated.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Preload.prefetchStatusUpdated", callback)

    def prerenderStatusUpdated(
        self,
        callback: Callable[['PrerenderStatusUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for prerenderStatusUpdated events.
        
        Fired when a prerender attempt is updated.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Preload.prerenderStatusUpdated", callback)

    def preloadingAttemptSourcesUpdated(
        self,
        callback: Callable[['PreloadingAttemptSourcesUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for preloadingAttemptSourcesUpdated events.
        
        Send a list of sources for all preloading attempts in a document.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Preload.preloadingAttemptSourcesUpdated", callback)

