# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Profiler Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import ConsoleProfileFinishedEvent, ConsoleProfileStartedEvent, PreciseCoverageDeltaUpdateEvent

class ProfilerRegistration:
    """Event registration interface for Profiler domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Profiler"

    def consoleProfileFinished(
        self,
        callback: Callable[['ConsoleProfileFinishedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for consoleProfileFinished events.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Profiler.consoleProfileFinished", callback)

    def consoleProfileStarted(
        self,
        callback: Callable[['ConsoleProfileStartedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for consoleProfileStarted events.
        
        Sent when new profile recording is started using console.profile() call.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Profiler.consoleProfileStarted", callback)

    def preciseCoverageDeltaUpdate(
        self,
        callback: Callable[['PreciseCoverageDeltaUpdateEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for preciseCoverageDeltaUpdate events.
        
        Reports coverage delta since the last poll (either from an event like this, or from
`takePreciseCoverage` for the current isolate. May only be sent if precise code
coverage has been started. This event can be trigged by the embedder to, for example,
trigger collection of coverage data immediately at a certain point in time.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Profiler.preciseCoverageDeltaUpdate", callback)

