# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Event Registry"""

import logging
from typing import Any, Callable, Dict, Optional

logger = logging.getLogger(__name__)

class EventRegistry:
    """Central registry for managing CDP event callbacks."""

    def __init__(self):
        self._handlers: Dict[str, Callable[[Any, Optional[str]], None]] = {}

    def register(
        self,
        method: str,
        callback: Callable[[Any, Optional[str]], None],
    ) -> None:
        """
        Register a callback for a specific CDP event method.
        
        Args:
            method: The CDP method name (e.g., "Page.frameAttached")
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        logger.debug(f"Registering handler for {method}")
        self._handlers[method] = callback

    def unregister(self, method: str) -> None:
        """
        Unregister a callback for a specific CDP event method.
        
        Args:
            method: The CDP method name to unregister
        """
        logger.debug(f"Unregistering handler for {method}")
        self._handlers.pop(method, None)

    async def handle_event(
        self,
        method: str,
        params: Any,
        session_id: Optional[str] = None,
    ) -> bool:
        """
        Handle an incoming CDP event.
        
        Args:
            method: The CDP method name
            params: The event parameters
            session_id: Optional session ID
            
        Returns:
            True if a handler was found and called, False otherwise
        """
        if method in self._handlers:
            try:
                import asyncio
                import inspect
                handler = self._handlers[method]
                
                # Check if handler is async
                if inspect.iscoroutinefunction(handler):
                    # Await async handlers
                    await handler(params, session_id)
                else:
                    # Call sync handlers directly
                    handler(params, session_id)
                return True
            except Exception as e:
                logger.error(f"Error in event handler for {method}: {e}")
                return False
        return False

    def clear(self) -> None:
        """Clear all registered handlers."""
        logger.debug("Clearing all event handlers")
        self._handlers.clear()

    def get_registered_methods(self) -> list[str]:
        """Get a list of all registered method names."""
        return list(self._handlers.keys())
