# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Runtime Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import (
    BindingCalledEvent,
    ConsoleAPICalledEvent,
    ExceptionRevokedEvent,
    ExceptionThrownEvent,
    ExecutionContextCreatedEvent,
    ExecutionContextDestroyedEvent,
    ExecutionContextsClearedEvent,
    InspectRequestedEvent
)

class RuntimeRegistration:
    """Event registration interface for Runtime domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Runtime"

    def bindingCalled(
        self,
        callback: Callable[['BindingCalledEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for bindingCalled events.
        
        Notification is issued every time when binding is called.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.bindingCalled", callback)

    def consoleAPICalled(
        self,
        callback: Callable[['ConsoleAPICalledEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for consoleAPICalled events.
        
        Issued when console API was called.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.consoleAPICalled", callback)

    def exceptionRevoked(
        self,
        callback: Callable[['ExceptionRevokedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for exceptionRevoked events.
        
        Issued when unhandled exception was revoked.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.exceptionRevoked", callback)

    def exceptionThrown(
        self,
        callback: Callable[['ExceptionThrownEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for exceptionThrown events.
        
        Issued when exception was thrown and unhandled.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.exceptionThrown", callback)

    def executionContextCreated(
        self,
        callback: Callable[['ExecutionContextCreatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for executionContextCreated events.
        
        Issued when new execution context is created.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.executionContextCreated", callback)

    def executionContextDestroyed(
        self,
        callback: Callable[['ExecutionContextDestroyedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for executionContextDestroyed events.
        
        Issued when execution context is destroyed.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.executionContextDestroyed", callback)

    def executionContextsCleared(
        self,
        callback: Callable[['ExecutionContextsClearedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for executionContextsCleared events.
        
        Issued when all executionContexts were cleared in browser
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.executionContextsCleared", callback)

    def inspectRequested(
        self,
        callback: Callable[['InspectRequestedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for inspectRequested events.
        
        Issued when object should be inspected (for example, as a result of inspect() command line API
call).
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Runtime.inspectRequested", callback)

