# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Security Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import HandleCertificateErrorParameters
    from .commands import SetIgnoreCertificateErrorsParameters
    from .commands import SetOverrideCertificateErrorsParameters

class SecurityClient:
    """Client for Security domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables tracking security state changes."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Security.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables tracking security state changes."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Security.enable",
            params=params,
            session_id=session_id,
        ))

    async def setIgnoreCertificateErrors(
        self,
        params: "SetIgnoreCertificateErrorsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enable/disable whether all certificate errors should be ignored."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Security.setIgnoreCertificateErrors",
            params=params,
            session_id=session_id,
        ))

    async def handleCertificateError(
        self,
        params: "HandleCertificateErrorParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Handles a certificate error that fired a certificateError event."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Security.handleCertificateError",
            params=params,
            session_id=session_id,
        ))

    async def setOverrideCertificateErrors(
        self,
        params: "SetOverrideCertificateErrorsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enable/disable overriding certificate errors. If enabled, all certificate error events need to
be handled by the DevTools client and should be answered with `handleCertificateError` commands."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Security.setOverrideCertificateErrors",
            params=params,
            session_id=session_id,
        ))


