# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Security Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import CertificateErrorEvent, SecurityStateChangedEvent, VisibleSecurityStateChangedEvent

class SecurityRegistration:
    """Event registration interface for Security domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Security"

    def certificateError(
        self,
        callback: Callable[['CertificateErrorEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for certificateError events.
        
        There is a certificate error. If overriding certificate errors is enabled, then it should be
handled with the `handleCertificateError` command. Note: this event does not fire if the
certificate error has been allowed internally. Only one client per target should override
certificate errors at the same time.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Security.certificateError", callback)

    def visibleSecurityStateChanged(
        self,
        callback: Callable[['VisibleSecurityStateChangedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for visibleSecurityStateChanged events.
        
        The security state of the page changed.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Security.visibleSecurityStateChanged", callback)

    def securityStateChanged(
        self,
        callback: Callable[['SecurityStateChangedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for securityStateChanged events.
        
        The security state of the page changed. No longer being sent.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Security.securityStateChanged", callback)

