# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP ServiceWorker Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import WorkerErrorReportedEvent, WorkerRegistrationUpdatedEvent, WorkerVersionUpdatedEvent

class ServiceWorkerRegistration:
    """Event registration interface for ServiceWorker domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "ServiceWorker"

    def workerErrorReported(
        self,
        callback: Callable[['WorkerErrorReportedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for workerErrorReported events.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("ServiceWorker.workerErrorReported", callback)

    def workerRegistrationUpdated(
        self,
        callback: Callable[['WorkerRegistrationUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for workerRegistrationUpdated events.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("ServiceWorker.workerRegistrationUpdated", callback)

    def workerVersionUpdated(
        self,
        callback: Callable[['WorkerVersionUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for workerVersionUpdated events.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("ServiceWorker.workerVersionUpdated", callback)

