# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP ServiceWorker Domain Types"""

from typing import List
from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..target.types import TargetID

RegistrationID = str



class ServiceWorkerRegistration(TypedDict):
    """ServiceWorker registration."""

    registrationId: "RegistrationID"
    scopeURL: "str"
    isDeleted: "bool"



ServiceWorkerVersionRunningStatus = Literal["stopped", "starting", "running", "stopping"]



ServiceWorkerVersionStatus = Literal["new", "installing", "installed", "activating", "activated", "redundant"]



class ServiceWorkerVersion(TypedDict):
    """ServiceWorker version."""

    versionId: "str"
    registrationId: "RegistrationID"
    scriptURL: "str"
    runningStatus: "ServiceWorkerVersionRunningStatus"
    status: "ServiceWorkerVersionStatus"
    scriptLastModified: "NotRequired[float]"
    """The Last-Modified header value of the main script."""
    scriptResponseTime: "NotRequired[float]"
    """The time at which the response headers of the main script were received from the server.
For cached script it is the last time the cache entry was validated."""
    controlledClients: "NotRequired[List[TargetID]]"
    targetId: "NotRequired[TargetID]"
    routerRules: "NotRequired[str]"



class ServiceWorkerErrorMessage(TypedDict):
    """ServiceWorker error message."""

    errorMessage: "str"
    registrationId: "RegistrationID"
    versionId: "str"
    sourceURL: "str"
    lineNumber: "int"
    columnNumber: "int"
