# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Storage Domain Commands"""

from typing import Any, Dict, List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..browser.types import BrowserContextID
    from ..network.types import Cookie
    from ..network.types import CookieParam
    from ..page.types import FrameId
    from .types import RelatedWebsiteSet
    from .types import SerializedStorageKey
    from .types import SharedStorageEntry
    from .types import SharedStorageMetadata
    from .types import StorageBucket
    from .types import TrustTokens
    from .types import UsageForType

class GetStorageKeyForFrameParameters(TypedDict):
    frameId: "FrameId"


class GetStorageKeyForFrameReturns(TypedDict):
    storageKey: "SerializedStorageKey"



class ClearDataForOriginParameters(TypedDict):
    origin: "str"
    """Security origin."""
    storageTypes: "str"
    """Comma separated list of StorageType to clear."""





class ClearDataForStorageKeyParameters(TypedDict):
    storageKey: "str"
    """Storage key."""
    storageTypes: "str"
    """Comma separated list of StorageType to clear."""





class GetCookiesParameters(TypedDict, total=False):
    browserContextId: "BrowserContextID"
    """Browser context to use when called on the browser endpoint."""


class GetCookiesReturns(TypedDict):
    cookies: "List[Cookie]"
    """Array of cookie objects."""



class SetCookiesParameters(TypedDict):
    cookies: "List[CookieParam]"
    """Cookies to be set."""
    browserContextId: "NotRequired[BrowserContextID]"
    """Browser context to use when called on the browser endpoint."""





class ClearCookiesParameters(TypedDict, total=False):
    browserContextId: "BrowserContextID"
    """Browser context to use when called on the browser endpoint."""





class GetUsageAndQuotaParameters(TypedDict):
    origin: "str"
    """Security origin."""


class GetUsageAndQuotaReturns(TypedDict):
    usage: "float"
    """Storage usage (bytes)."""
    quota: "float"
    """Storage quota (bytes)."""
    overrideActive: "bool"
    """Whether or not the origin has an active storage quota override"""
    usageBreakdown: "List[UsageForType]"
    """Storage usage per type (bytes)."""



class OverrideQuotaForOriginParameters(TypedDict):
    origin: "str"
    """Security origin."""
    quotaSize: "NotRequired[float]"
    """The quota size (in bytes) to override the original quota with.
If this is called multiple times, the overridden quota will be equal to
the quotaSize provided in the final call. If this is called without
specifying a quotaSize, the quota will be reset to the default value for
the specified origin. If this is called multiple times with different
origins, the override will be maintained for each origin until it is
disabled (called without a quotaSize)."""





class TrackCacheStorageForOriginParameters(TypedDict):
    origin: "str"
    """Security origin."""





class TrackCacheStorageForStorageKeyParameters(TypedDict):
    storageKey: "str"
    """Storage key."""





class TrackIndexedDBForOriginParameters(TypedDict):
    origin: "str"
    """Security origin."""





class TrackIndexedDBForStorageKeyParameters(TypedDict):
    storageKey: "str"
    """Storage key."""





class UntrackCacheStorageForOriginParameters(TypedDict):
    origin: "str"
    """Security origin."""





class UntrackCacheStorageForStorageKeyParameters(TypedDict):
    storageKey: "str"
    """Storage key."""





class UntrackIndexedDBForOriginParameters(TypedDict):
    origin: "str"
    """Security origin."""





class UntrackIndexedDBForStorageKeyParameters(TypedDict):
    storageKey: "str"
    """Storage key."""





class GetTrustTokensReturns(TypedDict):
    tokens: "List[TrustTokens]"



class ClearTrustTokensParameters(TypedDict):
    issuerOrigin: "str"


class ClearTrustTokensReturns(TypedDict):
    didDeleteTokens: "bool"
    """True if any tokens were deleted, false otherwise."""



class GetInterestGroupDetailsParameters(TypedDict):
    ownerOrigin: "str"
    name: "str"


class GetInterestGroupDetailsReturns(TypedDict):
    details: "Dict[str, Any]"
    """This largely corresponds to:
https://wicg.github.io/turtledove/#dictdef-generatebidinterestgroup
but has absolute expirationTime instead of relative lifetimeMs and
also adds joiningOrigin."""



class SetInterestGroupTrackingParameters(TypedDict):
    enable: "bool"





class SetInterestGroupAuctionTrackingParameters(TypedDict):
    enable: "bool"





class GetSharedStorageMetadataParameters(TypedDict):
    ownerOrigin: "str"


class GetSharedStorageMetadataReturns(TypedDict):
    metadata: "SharedStorageMetadata"



class GetSharedStorageEntriesParameters(TypedDict):
    ownerOrigin: "str"


class GetSharedStorageEntriesReturns(TypedDict):
    entries: "List[SharedStorageEntry]"



class SetSharedStorageEntryParameters(TypedDict):
    ownerOrigin: "str"
    key: "str"
    value: "str"
    ignoreIfPresent: "NotRequired[bool]"
    """If `ignoreIfPresent` is included and true, then only sets the entry if
`key` doesn't already exist."""





class DeleteSharedStorageEntryParameters(TypedDict):
    ownerOrigin: "str"
    key: "str"





class ClearSharedStorageEntriesParameters(TypedDict):
    ownerOrigin: "str"





class ResetSharedStorageBudgetParameters(TypedDict):
    ownerOrigin: "str"





class SetSharedStorageTrackingParameters(TypedDict):
    enable: "bool"





class SetStorageBucketTrackingParameters(TypedDict):
    storageKey: "str"
    enable: "bool"





class DeleteStorageBucketParameters(TypedDict):
    bucket: "StorageBucket"





class RunBounceTrackingMitigationsReturns(TypedDict):
    deletedSites: "List[str]"



class SetAttributionReportingLocalTestingModeParameters(TypedDict):
    enabled: "bool"
    """If enabled, noise is suppressed and reports are sent immediately."""





class SetAttributionReportingTrackingParameters(TypedDict):
    enable: "bool"





class SendPendingAttributionReportsReturns(TypedDict):
    numSent: "int"
    """The number of reports that were sent."""



class GetRelatedWebsiteSetsReturns(TypedDict):
    sets: "List[RelatedWebsiteSet]"



class GetAffectedUrlsForThirdPartyCookieMetadataParameters(TypedDict):
    firstPartyUrl: "str"
    """The URL of the page currently being visited."""
    thirdPartyUrls: "List[str]"
    """The list of embedded resource URLs from the page."""


class GetAffectedUrlsForThirdPartyCookieMetadataReturns(TypedDict):
    matchedUrls: "List[str]"
    """Array of matching URLs. If there is a primary pattern match for the first-
party URL, only the first-party URL is returned in the array."""



class SetProtectedAudienceKAnonymityParameters(TypedDict):
    owner: "str"
    name: "str"
    hashes: "List[str]"


