# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Storage Domain Events"""

from typing import Any, Dict, List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..network.types import RequestId
    from ..network.types import TimeSinceEpoch
    from ..page.types import FrameId
    from ..target.types import TargetID
    from .types import AttributionReportingAggregatableResult
    from .types import AttributionReportingEventLevelResult
    from .types import AttributionReportingReportResult
    from .types import AttributionReportingSourceRegistration
    from .types import AttributionReportingSourceRegistrationResult
    from .types import AttributionReportingTriggerRegistration
    from .types import InterestGroupAccessType
    from .types import InterestGroupAuctionEventType
    from .types import InterestGroupAuctionFetchType
    from .types import InterestGroupAuctionId
    from .types import SharedStorageAccessMethod
    from .types import SharedStorageAccessParams
    from .types import SharedStorageAccessScope
    from .types import StorageBucketInfo

"""A cache's contents have been modified."""
class CacheStorageContentUpdatedEvent(TypedDict):
    origin: "str"
    """Origin to update."""
    storageKey: "str"
    """Storage key to update."""
    bucketId: "str"
    """Storage bucket to update."""
    cacheName: "str"
    """Name of cache in origin."""



"""A cache has been added/deleted."""
class CacheStorageListUpdatedEvent(TypedDict):
    origin: "str"
    """Origin to update."""
    storageKey: "str"
    """Storage key to update."""
    bucketId: "str"
    """Storage bucket to update."""



"""The origin's IndexedDB object store has been modified."""
class IndexedDBContentUpdatedEvent(TypedDict):
    origin: "str"
    """Origin to update."""
    storageKey: "str"
    """Storage key to update."""
    bucketId: "str"
    """Storage bucket to update."""
    databaseName: "str"
    """Database to update."""
    objectStoreName: "str"
    """ObjectStore to update."""



"""The origin's IndexedDB database list has been modified."""
class IndexedDBListUpdatedEvent(TypedDict):
    origin: "str"
    """Origin to update."""
    storageKey: "str"
    """Storage key to update."""
    bucketId: "str"
    """Storage bucket to update."""



"""One of the interest groups was accessed. Note that these events are global
to all targets sharing an interest group store."""
class InterestGroupAccessedEvent(TypedDict):
    accessTime: "TimeSinceEpoch"
    type: "InterestGroupAccessType"
    ownerOrigin: "str"
    name: "str"
    componentSellerOrigin: "NotRequired[str]"
    """For topLevelBid/topLevelAdditionalBid, and when appropriate,
win and additionalBidWin"""
    bid: "NotRequired[float]"
    """For bid or somethingBid event, if done locally and not on a server."""
    bidCurrency: "NotRequired[str]"
    uniqueAuctionId: "NotRequired[InterestGroupAuctionId]"
    """For non-global events --- links to interestGroupAuctionEvent"""



"""An auction involving interest groups is taking place. These events are
target-specific."""
class InterestGroupAuctionEventOccurredEvent(TypedDict):
    eventTime: "TimeSinceEpoch"
    type: "InterestGroupAuctionEventType"
    uniqueAuctionId: "InterestGroupAuctionId"
    parentAuctionId: "NotRequired[InterestGroupAuctionId]"
    """Set for child auctions."""
    auctionConfig: "NotRequired[Dict[str, Any]]"
    """Set for started and configResolved"""



"""Specifies which auctions a particular network fetch may be related to, and
in what role. Note that it is not ordered with respect to
Network.requestWillBeSent (but will happen before loadingFinished
loadingFailed)."""
class InterestGroupAuctionNetworkRequestCreatedEvent(TypedDict):
    type: "InterestGroupAuctionFetchType"
    requestId: "RequestId"
    auctions: "List[InterestGroupAuctionId]"
    """This is the set of the auctions using the worklet that issued this
request.  In the case of trusted signals, it's possible that only some of
them actually care about the keys being queried."""



"""Shared storage was accessed by the associated page.
The following parameters are included in all events."""
class SharedStorageAccessedEvent(TypedDict):
    accessTime: "TimeSinceEpoch"
    """Time of the access."""
    scope: "SharedStorageAccessScope"
    """Enum value indicating the access scope."""
    method: "SharedStorageAccessMethod"
    """Enum value indicating the Shared Storage API method invoked."""
    mainFrameId: "FrameId"
    """DevTools Frame Token for the primary frame tree's root."""
    ownerOrigin: "str"
    """Serialization of the origin owning the Shared Storage data."""
    ownerSite: "str"
    """Serialization of the site owning the Shared Storage data."""
    params: "SharedStorageAccessParams"
    """The sub-parameters wrapped by `params` are all optional and their
presence/absence depends on `type`."""



"""A shared storage run or selectURL operation finished its execution.
The following parameters are included in all events."""
class SharedStorageWorkletOperationExecutionFinishedEvent(TypedDict):
    finishedTime: "TimeSinceEpoch"
    """Time that the operation finished."""
    executionTime: "int"
    """Time, in microseconds, from start of shared storage JS API call until
end of operation execution in the worklet."""
    method: "SharedStorageAccessMethod"
    """Enum value indicating the Shared Storage API method invoked."""
    operationId: "str"
    """ID of the operation call."""
    workletTargetId: "TargetID"
    """Hex representation of the DevTools token used as the TargetID for the
associated shared storage worklet."""
    mainFrameId: "FrameId"
    """DevTools Frame Token for the primary frame tree's root."""
    ownerOrigin: "str"
    """Serialization of the origin owning the Shared Storage data."""



class StorageBucketCreatedOrUpdatedEvent(TypedDict):
    bucketInfo: "StorageBucketInfo"



class StorageBucketDeletedEvent(TypedDict):
    bucketId: "str"



class AttributionReportingSourceRegisteredEvent(TypedDict):
    registration: "AttributionReportingSourceRegistration"
    result: "AttributionReportingSourceRegistrationResult"



class AttributionReportingTriggerRegisteredEvent(TypedDict):
    registration: "AttributionReportingTriggerRegistration"
    eventLevel: "AttributionReportingEventLevelResult"
    aggregatable: "AttributionReportingAggregatableResult"



class AttributionReportingReportSentEvent(TypedDict):
    url: "str"
    body: "Dict[str, Any]"
    result: "AttributionReportingReportResult"
    netError: "NotRequired[int]"
    """If result is `sent`, populated with net/HTTP status."""
    netErrorName: "NotRequired[str]"
    httpStatusCode: "NotRequired[int]"



class AttributionReportingVerboseDebugReportSentEvent(TypedDict):
    url: "str"
    body: "NotRequired[List[Dict[str, Any]]]"
    netError: "NotRequired[int]"
    netErrorName: "NotRequired[str]"
    httpStatusCode: "NotRequired[int]"
