# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Storage Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import ClearCookiesParameters
    from .commands import ClearDataForOriginParameters
    from .commands import ClearDataForStorageKeyParameters
    from .commands import ClearSharedStorageEntriesParameters
    from .commands import ClearTrustTokensParameters
    from .commands import ClearTrustTokensReturns
    from .commands import DeleteSharedStorageEntryParameters
    from .commands import DeleteStorageBucketParameters
    from .commands import GetAffectedUrlsForThirdPartyCookieMetadataParameters
    from .commands import GetAffectedUrlsForThirdPartyCookieMetadataReturns
    from .commands import GetCookiesParameters
    from .commands import GetCookiesReturns
    from .commands import GetInterestGroupDetailsParameters
    from .commands import GetInterestGroupDetailsReturns
    from .commands import GetRelatedWebsiteSetsReturns
    from .commands import GetSharedStorageEntriesParameters
    from .commands import GetSharedStorageEntriesReturns
    from .commands import GetSharedStorageMetadataParameters
    from .commands import GetSharedStorageMetadataReturns
    from .commands import GetStorageKeyForFrameParameters
    from .commands import GetStorageKeyForFrameReturns
    from .commands import GetTrustTokensReturns
    from .commands import GetUsageAndQuotaParameters
    from .commands import GetUsageAndQuotaReturns
    from .commands import OverrideQuotaForOriginParameters
    from .commands import ResetSharedStorageBudgetParameters
    from .commands import RunBounceTrackingMitigationsReturns
    from .commands import SendPendingAttributionReportsReturns
    from .commands import SetAttributionReportingLocalTestingModeParameters
    from .commands import SetAttributionReportingTrackingParameters
    from .commands import SetCookiesParameters
    from .commands import SetInterestGroupAuctionTrackingParameters
    from .commands import SetInterestGroupTrackingParameters
    from .commands import SetProtectedAudienceKAnonymityParameters
    from .commands import SetSharedStorageEntryParameters
    from .commands import SetSharedStorageTrackingParameters
    from .commands import SetStorageBucketTrackingParameters
    from .commands import TrackCacheStorageForOriginParameters
    from .commands import TrackCacheStorageForStorageKeyParameters
    from .commands import TrackIndexedDBForOriginParameters
    from .commands import TrackIndexedDBForStorageKeyParameters
    from .commands import UntrackCacheStorageForOriginParameters
    from .commands import UntrackCacheStorageForStorageKeyParameters
    from .commands import UntrackIndexedDBForOriginParameters
    from .commands import UntrackIndexedDBForStorageKeyParameters

class StorageClient:
    """Client for Storage domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def getStorageKeyForFrame(
        self,
        params: "GetStorageKeyForFrameParameters",
        session_id: Optional[str] = None,
    ) -> "GetStorageKeyForFrameReturns":
        """Returns a storage key given a frame id."""
        return cast("GetStorageKeyForFrameReturns", await self._client.send_raw(
            method="Storage.getStorageKeyForFrame",
            params=params,
            session_id=session_id,
        ))

    async def clearDataForOrigin(
        self,
        params: "ClearDataForOriginParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears storage for origin."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.clearDataForOrigin",
            params=params,
            session_id=session_id,
        ))

    async def clearDataForStorageKey(
        self,
        params: "ClearDataForStorageKeyParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears storage for storage key."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.clearDataForStorageKey",
            params=params,
            session_id=session_id,
        ))

    async def getCookies(
        self,
        params: Optional["GetCookiesParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetCookiesReturns":
        """Returns all browser cookies."""
        return cast("GetCookiesReturns", await self._client.send_raw(
            method="Storage.getCookies",
            params=params,
            session_id=session_id,
        ))

    async def setCookies(
        self,
        params: "SetCookiesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets given cookies."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setCookies",
            params=params,
            session_id=session_id,
        ))

    async def clearCookies(
        self,
        params: Optional["ClearCookiesParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears cookies."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.clearCookies",
            params=params,
            session_id=session_id,
        ))

    async def getUsageAndQuota(
        self,
        params: "GetUsageAndQuotaParameters",
        session_id: Optional[str] = None,
    ) -> "GetUsageAndQuotaReturns":
        """Returns usage and quota in bytes."""
        return cast("GetUsageAndQuotaReturns", await self._client.send_raw(
            method="Storage.getUsageAndQuota",
            params=params,
            session_id=session_id,
        ))

    async def overrideQuotaForOrigin(
        self,
        params: "OverrideQuotaForOriginParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Override quota for the specified origin"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.overrideQuotaForOrigin",
            params=params,
            session_id=session_id,
        ))

    async def trackCacheStorageForOrigin(
        self,
        params: "TrackCacheStorageForOriginParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Registers origin to be notified when an update occurs to its cache storage list."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.trackCacheStorageForOrigin",
            params=params,
            session_id=session_id,
        ))

    async def trackCacheStorageForStorageKey(
        self,
        params: "TrackCacheStorageForStorageKeyParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Registers storage key to be notified when an update occurs to its cache storage list."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.trackCacheStorageForStorageKey",
            params=params,
            session_id=session_id,
        ))

    async def trackIndexedDBForOrigin(
        self,
        params: "TrackIndexedDBForOriginParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Registers origin to be notified when an update occurs to its IndexedDB."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.trackIndexedDBForOrigin",
            params=params,
            session_id=session_id,
        ))

    async def trackIndexedDBForStorageKey(
        self,
        params: "TrackIndexedDBForStorageKeyParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Registers storage key to be notified when an update occurs to its IndexedDB."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.trackIndexedDBForStorageKey",
            params=params,
            session_id=session_id,
        ))

    async def untrackCacheStorageForOrigin(
        self,
        params: "UntrackCacheStorageForOriginParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Unregisters origin from receiving notifications for cache storage."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.untrackCacheStorageForOrigin",
            params=params,
            session_id=session_id,
        ))

    async def untrackCacheStorageForStorageKey(
        self,
        params: "UntrackCacheStorageForStorageKeyParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Unregisters storage key from receiving notifications for cache storage."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.untrackCacheStorageForStorageKey",
            params=params,
            session_id=session_id,
        ))

    async def untrackIndexedDBForOrigin(
        self,
        params: "UntrackIndexedDBForOriginParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Unregisters origin from receiving notifications for IndexedDB."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.untrackIndexedDBForOrigin",
            params=params,
            session_id=session_id,
        ))

    async def untrackIndexedDBForStorageKey(
        self,
        params: "UntrackIndexedDBForStorageKeyParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Unregisters storage key from receiving notifications for IndexedDB."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.untrackIndexedDBForStorageKey",
            params=params,
            session_id=session_id,
        ))

    async def getTrustTokens(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetTrustTokensReturns":
        """Returns the number of stored Trust Tokens per issuer for the
current browsing context."""
        return cast("GetTrustTokensReturns", await self._client.send_raw(
            method="Storage.getTrustTokens",
            params=params,
            session_id=session_id,
        ))

    async def clearTrustTokens(
        self,
        params: "ClearTrustTokensParameters",
        session_id: Optional[str] = None,
    ) -> "ClearTrustTokensReturns":
        """Removes all Trust Tokens issued by the provided issuerOrigin.
Leaves other stored data, including the issuer's Redemption Records, intact."""
        return cast("ClearTrustTokensReturns", await self._client.send_raw(
            method="Storage.clearTrustTokens",
            params=params,
            session_id=session_id,
        ))

    async def getInterestGroupDetails(
        self,
        params: "GetInterestGroupDetailsParameters",
        session_id: Optional[str] = None,
    ) -> "GetInterestGroupDetailsReturns":
        """Gets details for a named interest group."""
        return cast("GetInterestGroupDetailsReturns", await self._client.send_raw(
            method="Storage.getInterestGroupDetails",
            params=params,
            session_id=session_id,
        ))

    async def setInterestGroupTracking(
        self,
        params: "SetInterestGroupTrackingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables/Disables issuing of interestGroupAccessed events."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setInterestGroupTracking",
            params=params,
            session_id=session_id,
        ))

    async def setInterestGroupAuctionTracking(
        self,
        params: "SetInterestGroupAuctionTrackingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables/Disables issuing of interestGroupAuctionEventOccurred and
interestGroupAuctionNetworkRequestCreated."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setInterestGroupAuctionTracking",
            params=params,
            session_id=session_id,
        ))

    async def getSharedStorageMetadata(
        self,
        params: "GetSharedStorageMetadataParameters",
        session_id: Optional[str] = None,
    ) -> "GetSharedStorageMetadataReturns":
        """Gets metadata for an origin's shared storage."""
        return cast("GetSharedStorageMetadataReturns", await self._client.send_raw(
            method="Storage.getSharedStorageMetadata",
            params=params,
            session_id=session_id,
        ))

    async def getSharedStorageEntries(
        self,
        params: "GetSharedStorageEntriesParameters",
        session_id: Optional[str] = None,
    ) -> "GetSharedStorageEntriesReturns":
        """Gets the entries in an given origin's shared storage."""
        return cast("GetSharedStorageEntriesReturns", await self._client.send_raw(
            method="Storage.getSharedStorageEntries",
            params=params,
            session_id=session_id,
        ))

    async def setSharedStorageEntry(
        self,
        params: "SetSharedStorageEntryParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets entry with `key` and `value` for a given origin's shared storage."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setSharedStorageEntry",
            params=params,
            session_id=session_id,
        ))

    async def deleteSharedStorageEntry(
        self,
        params: "DeleteSharedStorageEntryParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deletes entry for `key` (if it exists) for a given origin's shared storage."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.deleteSharedStorageEntry",
            params=params,
            session_id=session_id,
        ))

    async def clearSharedStorageEntries(
        self,
        params: "ClearSharedStorageEntriesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears all entries for a given origin's shared storage."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.clearSharedStorageEntries",
            params=params,
            session_id=session_id,
        ))

    async def resetSharedStorageBudget(
        self,
        params: "ResetSharedStorageBudgetParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Resets the budget for `ownerOrigin` by clearing all budget withdrawals."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.resetSharedStorageBudget",
            params=params,
            session_id=session_id,
        ))

    async def setSharedStorageTracking(
        self,
        params: "SetSharedStorageTrackingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables/disables issuing of sharedStorageAccessed events."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setSharedStorageTracking",
            params=params,
            session_id=session_id,
        ))

    async def setStorageBucketTracking(
        self,
        params: "SetStorageBucketTrackingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set tracking for a storage key's buckets."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setStorageBucketTracking",
            params=params,
            session_id=session_id,
        ))

    async def deleteStorageBucket(
        self,
        params: "DeleteStorageBucketParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deletes the Storage Bucket with the given storage key and bucket name."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.deleteStorageBucket",
            params=params,
            session_id=session_id,
        ))

    async def runBounceTrackingMitigations(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "RunBounceTrackingMitigationsReturns":
        """Deletes state for sites identified as potential bounce trackers, immediately."""
        return cast("RunBounceTrackingMitigationsReturns", await self._client.send_raw(
            method="Storage.runBounceTrackingMitigations",
            params=params,
            session_id=session_id,
        ))

    async def setAttributionReportingLocalTestingMode(
        self,
        params: "SetAttributionReportingLocalTestingModeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """https://wicg.github.io/attribution-reporting-api/"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setAttributionReportingLocalTestingMode",
            params=params,
            session_id=session_id,
        ))

    async def setAttributionReportingTracking(
        self,
        params: "SetAttributionReportingTrackingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables/disables issuing of Attribution Reporting events."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setAttributionReportingTracking",
            params=params,
            session_id=session_id,
        ))

    async def sendPendingAttributionReports(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "SendPendingAttributionReportsReturns":
        """Sends all pending Attribution Reports immediately, regardless of their
scheduled report time."""
        return cast("SendPendingAttributionReportsReturns", await self._client.send_raw(
            method="Storage.sendPendingAttributionReports",
            params=params,
            session_id=session_id,
        ))

    async def getRelatedWebsiteSets(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetRelatedWebsiteSetsReturns":
        """Returns the effective Related Website Sets in use by this profile for the browser
session. The effective Related Website Sets will not change during a browser session."""
        return cast("GetRelatedWebsiteSetsReturns", await self._client.send_raw(
            method="Storage.getRelatedWebsiteSets",
            params=params,
            session_id=session_id,
        ))

    async def getAffectedUrlsForThirdPartyCookieMetadata(
        self,
        params: "GetAffectedUrlsForThirdPartyCookieMetadataParameters",
        session_id: Optional[str] = None,
    ) -> "GetAffectedUrlsForThirdPartyCookieMetadataReturns":
        """Returns the list of URLs from a page and its embedded resources that match
existing grace period URL pattern rules.
https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period"""
        return cast("GetAffectedUrlsForThirdPartyCookieMetadataReturns", await self._client.send_raw(
            method="Storage.getAffectedUrlsForThirdPartyCookieMetadata",
            params=params,
            session_id=session_id,
        ))

    async def setProtectedAudienceKAnonymity(
        self,
        params: "SetProtectedAudienceKAnonymityParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Storage.setProtectedAudienceKAnonymity",
            params=params,
            session_id=session_id,
        ))


