# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Target Domain Events"""

from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .types import SessionID
    from .types import TargetID
    from .types import TargetInfo

"""Issued when attached to target because of auto-attach or `attachToTarget` command."""
class AttachedToTargetEvent(TypedDict):
    sessionId: "SessionID"
    """Identifier assigned to the session used to send/receive messages."""
    targetInfo: "TargetInfo"
    waitingForDebugger: "bool"



"""Issued when detached from target for any reason (including `detachFromTarget` command). Can be
issued multiple times per target if multiple sessions have been attached to it."""
class DetachedFromTargetEvent(TypedDict):
    sessionId: "SessionID"
    """Detached session identifier."""
    targetId: "NotRequired[TargetID]"
    """Deprecated."""



"""Notifies about a new protocol message received from the session (as reported in
`attachedToTarget` event)."""
class ReceivedMessageFromTargetEvent(TypedDict):
    sessionId: "SessionID"
    """Identifier of a session which sends a message."""
    message: "str"
    targetId: "NotRequired[TargetID]"
    """Deprecated."""



"""Issued when a possible inspection target is created."""
class TargetCreatedEvent(TypedDict):
    targetInfo: "TargetInfo"



"""Issued when a target is destroyed."""
class TargetDestroyedEvent(TypedDict):
    targetId: "TargetID"



"""Issued when a target has crashed."""
class TargetCrashedEvent(TypedDict):
    targetId: "TargetID"
    status: "str"
    """Termination status type."""
    errorCode: "int"
    """Termination error code."""



"""Issued when some information about a target has changed. This only happens between
`targetCreated` and `targetDestroyed`."""
class TargetInfoChangedEvent(TypedDict):
    targetInfo: "TargetInfo"
