# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Target Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import (
    AttachedToTargetEvent,
    DetachedFromTargetEvent,
    ReceivedMessageFromTargetEvent,
    TargetCrashedEvent,
    TargetCreatedEvent,
    TargetDestroyedEvent,
    TargetInfoChangedEvent
)

class TargetRegistration:
    """Event registration interface for Target domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Target"

    def attachedToTarget(
        self,
        callback: Callable[['AttachedToTargetEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for attachedToTarget events.
        
        Issued when attached to target because of auto-attach or `attachToTarget` command.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.attachedToTarget", callback)

    def detachedFromTarget(
        self,
        callback: Callable[['DetachedFromTargetEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for detachedFromTarget events.
        
        Issued when detached from target for any reason (including `detachFromTarget` command). Can be
issued multiple times per target if multiple sessions have been attached to it.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.detachedFromTarget", callback)

    def receivedMessageFromTarget(
        self,
        callback: Callable[['ReceivedMessageFromTargetEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for receivedMessageFromTarget events.
        
        Notifies about a new protocol message received from the session (as reported in
`attachedToTarget` event).
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.receivedMessageFromTarget", callback)

    def targetCreated(
        self,
        callback: Callable[['TargetCreatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for targetCreated events.
        
        Issued when a possible inspection target is created.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.targetCreated", callback)

    def targetDestroyed(
        self,
        callback: Callable[['TargetDestroyedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for targetDestroyed events.
        
        Issued when a target is destroyed.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.targetDestroyed", callback)

    def targetCrashed(
        self,
        callback: Callable[['TargetCrashedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for targetCrashed events.
        
        Issued when a target has crashed.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.targetCrashed", callback)

    def targetInfoChanged(
        self,
        callback: Callable[['TargetInfoChangedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for targetInfoChanged events.
        
        Issued when some information about a target has changed. This only happens between
`targetCreated` and `targetDestroyed`.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Target.targetInfoChanged", callback)

