# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Tethering Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import BindParameters
    from .commands import UnbindParameters

class TetheringClient:
    """Client for Tethering domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def bind(
        self,
        params: "BindParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Request browser port binding."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Tethering.bind",
            params=params,
            session_id=session_id,
        ))

    async def unbind(
        self,
        params: "UnbindParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Request browser port unbinding."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Tethering.unbind",
            params=params,
            session_id=session_id,
        ))


