# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Tracing Domain Commands"""

from typing import List
from typing_extensions import TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .types import MemoryDumpLevelOfDetail
    from .types import StreamCompression
    from .types import StreamFormat
    from .types import TraceConfig
    from .types import TracingBackend

class GetCategoriesReturns(TypedDict):
    categories: "List[str]"
    """A list of supported tracing categories."""



class RecordClockSyncMarkerParameters(TypedDict):
    syncId: "str"
    """The ID of this clock sync marker"""





class RequestMemoryDumpParameters(TypedDict, total=False):
    deterministic: "bool"
    """Enables more deterministic results by forcing garbage collection"""
    levelOfDetail: "MemoryDumpLevelOfDetail"
    """Specifies level of details in memory dump. Defaults to \"detailed\"."""


class RequestMemoryDumpReturns(TypedDict):
    dumpGuid: "str"
    """GUID of the resulting global memory dump."""
    success: "bool"
    """True iff the global memory dump succeeded."""



class StartParameters(TypedDict, total=False):
    categories: "str"
    """Category/tag filter"""
    options: "str"
    """Tracing options"""
    bufferUsageReportingInterval: "float"
    """If set, the agent will issue bufferUsage events at this interval, specified in milliseconds"""
    transferMode: "str"
    """Whether to report trace events as series of dataCollected events or to save trace to a
stream (defaults to `ReportEvents`)."""
    streamFormat: "StreamFormat"
    """Trace data format to use. This only applies when using `ReturnAsStream`
transfer mode (defaults to `json`)."""
    streamCompression: "StreamCompression"
    """Compression format to use. This only applies when using `ReturnAsStream`
transfer mode (defaults to `none`)"""
    traceConfig: "TraceConfig"
    perfettoConfig: "str"
    """Base64-encoded serialized perfetto.protos.TraceConfig protobuf message
When specified, the parameters `categories`, `options`, `traceConfig`
are ignored. (Encoded as a base64 string when passed over JSON)"""
    tracingBackend: "TracingBackend"
    """Backend type (defaults to `auto`)"""


