# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP WebAudio Domain Types"""

from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

GraphObjectId = str
"""An unique ID for a graph object (AudioContext, AudioNode, AudioParam) in Web Audio API"""



ContextType = Literal["realtime", "offline"]
"""Enum of BaseAudioContext types"""



ContextState = Literal["suspended", "running", "closed", "interrupted"]
"""Enum of AudioContextState from the spec"""



NodeType = str
"""Enum of AudioNode types"""



ChannelCountMode = Literal["clamped-max", "explicit", "max"]
"""Enum of AudioNode::ChannelCountMode from the spec"""



ChannelInterpretation = Literal["discrete", "speakers"]
"""Enum of AudioNode::ChannelInterpretation from the spec"""



ParamType = str
"""Enum of AudioParam types"""



AutomationRate = Literal["a-rate", "k-rate"]
"""Enum of AudioParam::AutomationRate from the spec"""



class ContextRealtimeData(TypedDict):
    """Fields in AudioContext that change in real-time."""

    currentTime: "float"
    """The current context time in second in BaseAudioContext."""
    renderCapacity: "float"
    """The time spent on rendering graph divided by render quantum duration,
and multiplied by 100. 100 means the audio renderer reached the full
capacity and glitch may occur."""
    callbackIntervalMean: "float"
    """A running mean of callback interval."""
    callbackIntervalVariance: "float"
    """A running variance of callback interval."""



class BaseAudioContext(TypedDict):
    """Protocol object for BaseAudioContext"""

    contextId: "GraphObjectId"
    contextType: "ContextType"
    contextState: "ContextState"
    realtimeData: "NotRequired[ContextRealtimeData]"
    callbackBufferSize: "float"
    """Platform-dependent callback buffer size."""
    maxOutputChannelCount: "float"
    """Number of output channels supported by audio hardware in use."""
    sampleRate: "float"
    """Context sample rate."""



class AudioListener(TypedDict):
    """Protocol object for AudioListener"""

    listenerId: "GraphObjectId"
    contextId: "GraphObjectId"



class AudioNode(TypedDict):
    """Protocol object for AudioNode"""

    nodeId: "GraphObjectId"
    contextId: "GraphObjectId"
    nodeType: "NodeType"
    numberOfInputs: "float"
    numberOfOutputs: "float"
    channelCount: "float"
    channelCountMode: "ChannelCountMode"
    channelInterpretation: "ChannelInterpretation"



class AudioParam(TypedDict):
    """Protocol object for AudioParam"""

    paramId: "GraphObjectId"
    nodeId: "GraphObjectId"
    contextId: "GraphObjectId"
    paramType: "ParamType"
    rate: "AutomationRate"
    defaultValue: "float"
    minValue: "float"
    maxValue: "float"
