# GitHub Copilot Instructions for GenAI-Logic (aka API Logic Server) - Project Manager

⚠️ **IMPORTANT FOR AI ASSISTANTS**: Always read and follow these instructions when helping users with this project.

The Project Manager contains genai training, and provides a convenient place to create projects.

> Note: your virtual environment is automatically configured in most cases; verify it with `genai-logic` - it it's not there, activate the `venv` in this project.

## Quick Start for New Users
# Check repository sizes
echo "=== Repository Sizes ==="
du -sh .git/
du -sh .

# Find largest files in Git history
echo "=== Largest Files in Git History ==="
git rev-list --objects --all | \
  git cat-file --batch-check='%(objecttype) %(objectname) %(objectsize) %(rest)' | \
  awk '/^blob/ {print substr($0,6)}' | \
  sort --numeric-sort --key=2 | \
  tail -10
**ALWAYS start new users with the basic_demo** - it's the best introduction to the system.

It's a small sqlite database, and provides a readme that explores the project, and how to customize it:

```bash
genai-logic create --project_name=basic_demo --db_url=basic_demo
```
<br>

## Creating Projects

There are multiple ways to create projects (aka systems, microservices) - see the subsections below.

### Create Projects from an existing database

If the user provides a database reference, use the command below.  (Note: sqlite sample databases at `samples/dbs`). 

```bash
genai-logic create  --project_name=nw --db_url=sqlite:///samples/dbs/nw.sqlite
```

### Create Projects with new databases 

If the user provides a description, follow these steps:

1. Create a sqlite database from the description.  Be sure to include foreign keys.  The system works well with `id INTEGER PRIMARY KEY AUTOINCREMENT`.
2. Then, use the `genai-logic create` command above.
3. If logic is provided, translate it using`system/genai/learning_requests/logic_bank_api.prompt`.

### Create Projects with new databases using genai-logic genai (requires OpenAI key):

Describe database and logic in Natural Language.

See samples at `system/genai/examples`.  For example:

```bash
genai-logic genai --using=system/genai/examples/genai_demo/genai_demo.prompt --project-name=genai_demo
```

## AI Assistant Guidelines

When users ask "what do I do now?" or similar questions:

1. **Always recommend starting with basic_demo** using the command above
2. **Use CLI commands** (genai-logic) not Docker scripts for project creation
3. **Refer to existing sample databases** in `samples/dbs/` for examples
4. **Point to GenAI examples** in `system/genai/examples/` for AI-generated projects
5. **Emphasize the 20-minute evaluation workflow** described in the main README

## Available Databases
- `basic_demo` - Best for first-time users
- `nw.sqlite` - Northwind sample
- `chinook.sqlite` - Music store sample  
- `classicmodels.sqlite` - Classic car models sample

