# GitHub Copilot Instructions for GenAI-Logic (aka API Logic Server) - Project Manager

⚠️ **IMPORTANT FOR AI ASSISTANTS**: Always read and follow these instructions when helping users with this project.

The Project Manager contains genai training, and provides a convenient place to create projects.

## Quick Start for New Users

**ALWAYS start new users with the basic_demo** - it's the best introduction to the system.

## Creating Projects

There are multiple ways to create projects - see the subsections below.

### Create Projects from an existing database

sqlite sample databases at `samples/dbs`.

```bash
genai-logic create  --project_name=nw --db_url=sqlite:///samples/dbs/nw.sqlite
```

### Create Projects with new databases (requires OpenAI key):

Describe database and logic in Natural Language.

See samples at `system/genai/examples`.  For example:

```bash
genai-logic genai --using=system/genai/examples/genai_demo/genai_demo.prompt --project-name=genai_demo
```

### Sample basic_demo

The best place to start is to create the `basic_demo`.

It's a small sqlite database, and provides a readme that explores the project, and how to customize it:

```bash
genai-logic create --project_name=basic_demo --db_url=basic_demo
```

## AI Assistant Guidelines

When users ask "what do I do now?" or similar questions:

1. **Always recommend starting with basic_demo** using the command above
2. **Use CLI commands** (genai-logic) not Docker scripts for project creation
3. **Refer to existing sample databases** in `samples/dbs/` for examples
4. **Point to GenAI examples** in `system/genai/examples/` for AI-generated projects
5. **Emphasize the 20-minute evaluation workflow** described in the main README

## Available Databases
- `basic_demo` - Best for first-time users
- `nw.sqlite` - Northwind sample
- `chinook.sqlite` - Music store sample  
- `classicmodels.sqlite` - Classic car models sample

