# Time Tracking and Billing 
 Here, we create a time-tracking system, being specific about tables and columns in the [002_create_db_models.prompt](./).  Each table has additional attributes that are used to hold sums, counts, and formula.  Each table has a Use Case definition that describes the business logic using natural language.  

## Command Line - create this system:
```bash
# create the time_track system
$als genai --project-name=time_track --using=system/genai/examples/time_tracking_billing/002_create_db_models.prompt
```

## Review the created system
Open the time_track in VSCode or CodeSpaces and start the ApiLogicServer (F5). This will start the server and the react-admin site (http://localhost:5656). You should see Client, Project, Task, Timesheet, Person, and Invoice with sample data generated by WebGenAI.  

## Review the Logic
The /logic directory contains the generated logic (/logic/wg_rules).  This will show how natural language is translated into LogicBank rules (/logic/wg_rules/active_rules_export.py). The other rules[n].py in the wg_rules folder are used and tested by WebGenAI and can be ignored.

```
    # Exported Rules:
    # Rule 1 
    # Total Hours entered is sum of timesheet hours worked
    Rule.sum(derive=Person.total_hours_entered, as_sum_of=Timesheet.hours_worked)
    
```

## Add Security and Enable Defaults
The authentication service can be added using the command line
```
$als add-auth --provider-type=sql # Local SQLIte
$als add-auth --provider-type=keycloak # Local KeyCloak (see docs)
$als add-auth --provider-type=sql --db-url={database config} # Use SQL database User/Role
```
To ensure defaults are applied (impacts rules) we need to add a global environment variable in the environment and restart the application.
ALL_DEFAULTS=True

## Add Ontimize Application
To create an angular Ontimize application, you need to follow these steps.  Note the name 'app' is your project name which you can change or create another project.
```
$cd timetrack
$als app-create --app=app #if the ui/app folder does not exist
$als app-build --app=app # generates pages from the API entities
$cd ui/app

$npm install && npm start  # install and start the NodeJS/Angular app

# Launch your new Ontimize application (http://localhost:4299)

```

## Testing Time Tracker and Billing
You can delete the existing sample data or you can start by entering new data.  To test the logic - follow these steps:
```
1. Enter new Client
2. Enter new Person (works for Client, Billing Rate 100)
3. Enter new Project for client
4. Enter new Task for Project
5. Enter new Timesheet - enter task and person for client (enter hours worked)

Watch Rules fired in log and then review the sums, counts, formula and constraints.
Note: The Client total amount should be the same value as Project, Task, and Timesheet.

Bonus: Enter an Invoice for a Client/Project then add Invoice Item for a specific Client Task. Once the invoice is ready - we can add a new Event (logic) to send to Kafka.
```
