# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

import types

__config__ = pulumi.Config('snowflake')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def account_name(self) -> Optional[str]:
        """
        Specifies your Snowflake account name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#account-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ACCOUNT_NAME` environment variable.
        """
        return __config__.get('accountName')

    @_builtins.property
    def authenticator(self) -> Optional[str]:
        """
        Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid options are: `SNOWFLAKE` | `OAUTH` | `EXTERNALBROWSER` | `OKTA` | `SNOWFLAKE_JWT` | `TOKENACCESSOR` | `USERNAMEPASSWORDMFA` | `PROGRAMMATIC_ACCESS_TOKEN` | `OAUTH_CLIENT_CREDENTIALS` | `OAUTH_AUTHORIZATION_CODE` | `WORKLOAD_IDENTITY`. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable.
        """
        return __config__.get('authenticator')

    @_builtins.property
    def client_ip(self) -> Optional[str]:
        """
        IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
        """
        return __config__.get('clientIp')

    @_builtins.property
    def client_request_mfa_token(self) -> Optional[str]:
        """
        When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
        """
        return __config__.get('clientRequestMfaToken')

    @_builtins.property
    def client_store_temporary_credential(self) -> Optional[str]:
        """
        When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
        """
        return __config__.get('clientStoreTemporaryCredential')

    @_builtins.property
    def client_timeout(self) -> Optional[int]:
        """
        The timeout in seconds for the client to complete the authentication. Can also be sourced from the `SNOWFLAKE_CLIENT_TIMEOUT` environment variable.
        """
        return __config__.get_int('clientTimeout')

    @_builtins.property
    def disable_console_login(self) -> Optional[str]:
        """
        Indicates whether console login should be disabled in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_CONSOLE_LOGIN` environment variable.
        """
        return __config__.get('disableConsoleLogin')

    @_builtins.property
    def disable_query_context_cache(self) -> Optional[bool]:
        """
        Disables HTAP query context cache in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_QUERY_CONTEXT_CACHE` environment variable.
        """
        return __config__.get_bool('disableQueryContextCache')

    @_builtins.property
    def disable_telemetry(self) -> Optional[bool]:
        """
        Disables telemetry in the driver. Can also be sourced from the `DISABLE_TELEMETRY` environment variable.
        """
        return __config__.get_bool('disableTelemetry')

    @_builtins.property
    def driver_tracing(self) -> Optional[str]:
        """
        Specifies the logging level to be used by the driver. Valid options are: `trace` | `debug` | `info` | `print` | `warning` | `error` | `fatal` | `panic`. Can also be sourced from the `SNOWFLAKE_DRIVER_TRACING` environment variable.
        """
        return __config__.get('driverTracing')

    @_builtins.property
    def enable_single_use_refresh_tokens(self) -> Optional[bool]:
        """
        Enables single use refresh tokens for Snowflake IdP. Can also be sourced from the `SNOWFLAKE_ENABLE_SINGLE_USE_REFRESH_TOKENS` environment variable.
        """
        return __config__.get_bool('enableSingleUseRefreshTokens')

    @_builtins.property
    def experimental_features_enableds(self) -> Optional[str]:
        """
        A list of experimental features. Similarly to preview features, they are not yet stable features of the provider. Enabling given experiment is still considered a preview feature, even when applied to the stable resource. These switches offer experiments altering the provider behavior. If the given experiment is successful, it can be considered an addition in the future provider versions. This field can not be set with environmental variables. Valid options are: `PARAMETERS_IGNORE_VALUE_CHANGES_IF_NOT_ON_OBJECT_LEVEL` | `WAREHOUSE_SHOW_IMPROVED_PERFORMANCE`.
        """
        return __config__.get('experimentalFeaturesEnableds')

    @_builtins.property
    def external_browser_timeout(self) -> Optional[int]:
        """
        The timeout in seconds for the external browser to complete the authentication. Can also be sourced from the `SNOWFLAKE_EXTERNAL_BROWSER_TIMEOUT` environment variable.
        """
        return __config__.get_int('externalBrowserTimeout')

    @_builtins.property
    def host(self) -> Optional[str]:
        """
        Specifies a custom host value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
        """
        return __config__.get('host') or _utilities.get_env('SNOWFLAKE_HOST')

    @_builtins.property
    def include_retry_reason(self) -> Optional[str]:
        """
        Should retried request contain retry reason. Can also be sourced from the `SNOWFLAKE_INCLUDE_RETRY_REASON` environment variable.
        """
        return __config__.get('includeRetryReason')

    @_builtins.property
    def insecure_mode(self) -> Optional[bool]:
        """
        If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the default value for testing or emergency situations only. Can also be sourced from the `SNOWFLAKE_INSECURE_MODE` environment variable.
        """
        return __config__.get_bool('insecureMode')

    @_builtins.property
    def jwt_client_timeout(self) -> Optional[int]:
        """
        The timeout in seconds for the JWT client to complete the authentication. Can also be sourced from the `SNOWFLAKE_JWT_CLIENT_TIMEOUT` environment variable.
        """
        return __config__.get_int('jwtClientTimeout')

    @_builtins.property
    def jwt_expire_timeout(self) -> Optional[int]:
        """
        JWT expire after timeout in seconds. Can also be sourced from the `SNOWFLAKE_JWT_EXPIRE_TIMEOUT` environment variable.
        """
        return __config__.get_int('jwtExpireTimeout')

    @_builtins.property
    def keep_session_alive(self) -> Optional[bool]:
        """
        Enables the session to persist even after the connection is closed. Can also be sourced from the `SNOWFLAKE_KEEP_SESSION_ALIVE` environment variable.
        """
        return __config__.get_bool('keepSessionAlive')

    @_builtins.property
    def login_timeout(self) -> Optional[int]:
        """
        Login retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_LOGIN_TIMEOUT` environment variable.
        """
        return __config__.get_int('loginTimeout')

    @_builtins.property
    def max_retry_count(self) -> Optional[int]:
        """
        Specifies how many times non-periodic HTTP request can be retried by the driver. Can also be sourced from the `SNOWFLAKE_MAX_RETRY_COUNT` environment variable.
        """
        return __config__.get_int('maxRetryCount')

    @_builtins.property
    def oauth_authorization_url(self) -> Optional[str]:
        """
        Authorization URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_AUTHORIZATION_URL` environment variable.
        """
        return __config__.get('oauthAuthorizationUrl')

    @_builtins.property
    def oauth_client_id(self) -> Optional[str]:
        """
        Client id for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        """
        return __config__.get('oauthClientId')

    @_builtins.property
    def oauth_client_secret(self) -> Optional[str]:
        """
        Client secret for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        """
        return __config__.get('oauthClientSecret')

    @_builtins.property
    def oauth_redirect_uri(self) -> Optional[str]:
        """
        Redirect URI registered in IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_REDIRECT_URI` environment variable.
        """
        return __config__.get('oauthRedirectUri')

    @_builtins.property
    def oauth_scope(self) -> Optional[str]:
        """
        Comma separated list of scopes. If empty it is derived from role. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_SCOPE` environment variable.
        """
        return __config__.get('oauthScope')

    @_builtins.property
    def oauth_token_request_url(self) -> Optional[str]:
        """
        Token request URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_TOKEN_REQUEST_URL` environment variable.
        """
        return __config__.get('oauthTokenRequestUrl')

    @_builtins.property
    def ocsp_fail_open(self) -> Optional[str]:
        """
        True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
        """
        return __config__.get('ocspFailOpen')

    @_builtins.property
    def okta_url(self) -> Optional[str]:
        """
        The URL of the Okta server. e.g. https://example.okta.com. Okta URL host needs to to have a suffix `okta.com`. Read more in Snowflake [docs](https://docs.snowflake.com/en/user-guide/oauth-okta). Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
        """
        return __config__.get('oktaUrl')

    @_builtins.property
    def organization_name(self) -> Optional[str]:
        """
        Specifies your Snowflake organization name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#organization-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ORGANIZATION_NAME` environment variable.
        """
        return __config__.get('organizationName')

    @_builtins.property
    def params(self) -> Optional[str]:
        """
        Sets other connection (i.e. session) parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters). This field can not be set with environmental variables.
        """
        return __config__.get('params')

    @_builtins.property
    def passcode(self) -> Optional[str]:
        """
        Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
        """
        return __config__.get('passcode')

    @_builtins.property
    def passcode_in_password(self) -> Optional[bool]:
        """
        False by default. Set to true if the MFA passcode is embedded to the configured password. Can also be sourced from the `SNOWFLAKE_PASSCODE_IN_PASSWORD` environment variable.
        """
        return __config__.get_bool('passcodeInPassword')

    @_builtins.property
    def password(self) -> Optional[str]:
        """
        Password for user + password or [token](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens#generating-a-programmatic-access-token) for [PAT auth](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens). Cannot be used with `private_key` and `private_key_passphrase`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
        """
        return __config__.get('password') or _utilities.get_env('SNOWFLAKE_PASSWORD')

    @_builtins.property
    def port(self) -> Optional[int]:
        """
        Specifies a custom port value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_PORT` environment variable.
        """
        return __config__.get_int('port') or _utilities.get_env_int('SNOWFLAKE_PORT')

    @_builtins.property
    def preview_features_enabled(self) -> Optional[str]:
        return __config__.get('previewFeaturesEnabled')

    @_builtins.property
    def private_key(self) -> Optional[str]:
        """
        Private Key for username+private-key auth. Cannot be used with `password`. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY` environment variable.
        """
        return __config__.get('privateKey')

    @_builtins.property
    def private_key_passphrase(self) -> Optional[str]:
        """
        Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
        """
        return __config__.get('privateKeyPassphrase') or _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PASSPHRASE')

    @_builtins.property
    def profile(self) -> Optional[str]:
        """
        Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
        """
        return __config__.get('profile')

    @_builtins.property
    def protocol(self) -> Optional[str]:
        """
        A protocol used in the connection. Valid options are: `http` | `https`. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
        """
        return __config__.get('protocol') or _utilities.get_env('SNOWFLAKE_PROTOCOL')

    @_builtins.property
    def request_timeout(self) -> Optional[int]:
        """
        request retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_REQUEST_TIMEOUT` environment variable.
        """
        return __config__.get_int('requestTimeout')

    @_builtins.property
    def role(self) -> Optional[str]:
        """
        Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable.
        """
        return __config__.get('role') or _utilities.get_env('SNOWFLAKE_ROLE')

    @_builtins.property
    def skip_toml_file_permission_verification(self) -> Optional[bool]:
        """
        False by default. Skips TOML configuration file permission verification. This flag has no effect on Windows systems, as the permissions are not checked on this platform. Instead of skipping the permissions verification, we recommend setting the proper privileges - see the section below. Can also be sourced from the `SNOWFLAKE_SKIP_TOML_FILE_PERMISSION_VERIFICATION` environment variable.
        """
        return __config__.get_bool('skipTomlFilePermissionVerification')

    @_builtins.property
    def tmp_directory_path(self) -> Optional[str]:
        """
        Sets temporary directory used by the driver for operations like encrypting, compressing etc. Can also be sourced from the `SNOWFLAKE_TMP_DIRECTORY_PATH` environment variable.
        """
        return __config__.get('tmpDirectoryPath')

    @_builtins.property
    def token(self) -> Optional[str]:
        """
        Token to use for OAuth and other forms of token based auth. When this field is set here, or in the TOML file, the provider sets the `authenticator` to `OAUTH`. Optionally, set the `authenticator` field to the authenticator you want to use. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
        """
        return __config__.get('token')

    @_builtins.property
    def token_accessor(self) -> Optional[str]:
        """
        If you are using the OAuth authentication flows, use the dedicated `authenticator` and `oauth...` fields instead. See our authentication methods guide for more information.
        """
        return __config__.get('tokenAccessor')

    @_builtins.property
    def use_legacy_toml_file(self) -> Optional[bool]:
        """
        False by default. When this is set to true, the provider expects the legacy TOML format. Otherwise, it expects the new format. See more in the section below Can also be sourced from the `SNOWFLAKE_USE_LEGACY_TOML_FILE` environment variable.
        """
        return __config__.get_bool('useLegacyTomlFile')

    @_builtins.property
    def user(self) -> Optional[str]:
        """
        Username. Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_USER` environment variable.
        """
        return __config__.get('user')

    @_builtins.property
    def validate_default_parameters(self) -> Optional[str]:
        """
        True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
        """
        return __config__.get('validateDefaultParameters')

    @_builtins.property
    def warehouse(self) -> Optional[str]:
        """
        Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
        """
        return __config__.get('warehouse') or _utilities.get_env('SNOWFLAKE_WAREHOUSE')

    @_builtins.property
    def workload_identity_entra_resource(self) -> Optional[str]:
        """
        The resource to use for WIF authentication on Azure environment. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_ENTRA_RESOURCE` environment variable.
        """
        return __config__.get('workloadIdentityEntraResource')

    @_builtins.property
    def workload_identity_provider(self) -> Optional[str]:
        """
        The workload identity provider to use for WIF authentication. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_PROVIDER` environment variable.
        """
        return __config__.get('workloadIdentityProvider')

