# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 catalog: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_retention_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 default_ddl_collation: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_public_schema_on_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 is_transient: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_data_extension_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication: Optional[pulumi.Input['DatabaseReplicationArgs']] = None,
                 storage_serialization_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[_builtins.str] catalog: The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the database.
        :param pulumi.Input[_builtins.int] data_retention_time_in_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        :param pulumi.Input[_builtins.str] default_ddl_collation: Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        :param pulumi.Input[_builtins.bool] drop_public_schema_on_creation: Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        :param pulumi.Input[_builtins.bool] enable_console_output: If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        :param pulumi.Input[_builtins.str] external_volume: The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        :param pulumi.Input[_builtins.bool] is_transient: Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        :param pulumi.Input[_builtins.int] max_data_extension_time_in_days: Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        :param pulumi.Input['DatabaseReplicationArgs'] replication: Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        :param pulumi.Input[_builtins.str] storage_serialization_policy: The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds.
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_retention_time_in_days is not None:
            pulumi.set(__self__, "data_retention_time_in_days", data_retention_time_in_days)
        if default_ddl_collation is not None:
            pulumi.set(__self__, "default_ddl_collation", default_ddl_collation)
        if drop_public_schema_on_creation is not None:
            pulumi.set(__self__, "drop_public_schema_on_creation", drop_public_schema_on_creation)
        if enable_console_output is not None:
            pulumi.set(__self__, "enable_console_output", enable_console_output)
        if external_volume is not None:
            pulumi.set(__self__, "external_volume", external_volume)
        if is_transient is not None:
            pulumi.set(__self__, "is_transient", is_transient)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if max_data_extension_time_in_days is not None:
            pulumi.set(__self__, "max_data_extension_time_in_days", max_data_extension_time_in_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quoted_identifiers_ignore_case is not None:
            pulumi.set(__self__, "quoted_identifiers_ignore_case", quoted_identifiers_ignore_case)
        if replace_invalid_characters is not None:
            pulumi.set(__self__, "replace_invalid_characters", replace_invalid_characters)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if storage_serialization_policy is not None:
            pulumi.set(__self__, "storage_serialization_policy", storage_serialization_policy)
        if suspend_task_after_num_failures is not None:
            pulumi.set(__self__, "suspend_task_after_num_failures", suspend_task_after_num_failures)
        if task_auto_retry_attempts is not None:
            pulumi.set(__self__, "task_auto_retry_attempts", task_auto_retry_attempts)
        if trace_level is not None:
            pulumi.set(__self__, "trace_level", trace_level)
        if user_task_managed_initial_warehouse_size is not None:
            pulumi.set(__self__, "user_task_managed_initial_warehouse_size", user_task_managed_initial_warehouse_size)
        if user_task_minimum_trigger_interval_in_seconds is not None:
            pulumi.set(__self__, "user_task_minimum_trigger_interval_in_seconds", user_task_minimum_trigger_interval_in_seconds)
        if user_task_timeout_ms is not None:
            pulumi.set(__self__, "user_task_timeout_ms", user_task_timeout_ms)

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="dataRetentionTimeInDays")
    def data_retention_time_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        """
        return pulumi.get(self, "data_retention_time_in_days")

    @data_retention_time_in_days.setter
    def data_retention_time_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_retention_time_in_days", value)

    @_builtins.property
    @pulumi.getter(name="defaultDdlCollation")
    def default_ddl_collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        """
        return pulumi.get(self, "default_ddl_collation")

    @default_ddl_collation.setter
    def default_ddl_collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ddl_collation", value)

    @_builtins.property
    @pulumi.getter(name="dropPublicSchemaOnCreation")
    def drop_public_schema_on_creation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        """
        return pulumi.get(self, "drop_public_schema_on_creation")

    @drop_public_schema_on_creation.setter
    def drop_public_schema_on_creation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drop_public_schema_on_creation", value)

    @_builtins.property
    @pulumi.getter(name="enableConsoleOutput")
    def enable_console_output(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        """
        return pulumi.get(self, "enable_console_output")

    @enable_console_output.setter
    def enable_console_output(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_console_output", value)

    @_builtins.property
    @pulumi.getter(name="externalVolume")
    def external_volume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        """
        return pulumi.get(self, "external_volume")

    @external_volume.setter
    def external_volume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_volume", value)

    @_builtins.property
    @pulumi.getter(name="isTransient")
    def is_transient(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        """
        return pulumi.get(self, "is_transient")

    @is_transient.setter
    def is_transient(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_transient", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter(name="maxDataExtensionTimeInDays")
    def max_data_extension_time_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        """
        return pulumi.get(self, "max_data_extension_time_in_days")

    @max_data_extension_time_in_days.setter
    def max_data_extension_time_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_data_extension_time_in_days", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="quotedIdentifiersIgnoreCase")
    def quoted_identifiers_ignore_case(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        """
        return pulumi.get(self, "quoted_identifiers_ignore_case")

    @quoted_identifiers_ignore_case.setter
    def quoted_identifiers_ignore_case(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quoted_identifiers_ignore_case", value)

    @_builtins.property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @replace_invalid_characters.setter
    def replace_invalid_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace_invalid_characters", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input['DatabaseReplicationArgs']]:
        """
        Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input['DatabaseReplicationArgs']]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter(name="storageSerializationPolicy")
    def storage_serialization_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        """
        return pulumi.get(self, "storage_serialization_policy")

    @storage_serialization_policy.setter
    def storage_serialization_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_serialization_policy", value)

    @_builtins.property
    @pulumi.getter(name="suspendTaskAfterNumFailures")
    def suspend_task_after_num_failures(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        """
        return pulumi.get(self, "suspend_task_after_num_failures")

    @suspend_task_after_num_failures.setter
    def suspend_task_after_num_failures(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_task_after_num_failures", value)

    @_builtins.property
    @pulumi.getter(name="taskAutoRetryAttempts")
    def task_auto_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        """
        return pulumi.get(self, "task_auto_retry_attempts")

    @task_auto_retry_attempts.setter
    def task_auto_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "task_auto_retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        """
        return pulumi.get(self, "trace_level")

    @trace_level.setter
    def trace_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_level", value)

    @_builtins.property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @user_task_managed_initial_warehouse_size.setter
    def user_task_managed_initial_warehouse_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_task_managed_initial_warehouse_size", value)

    @_builtins.property
    @pulumi.getter(name="userTaskMinimumTriggerIntervalInSeconds")
    def user_task_minimum_trigger_interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum amount of time between Triggered Task executions in seconds.
        """
        return pulumi.get(self, "user_task_minimum_trigger_interval_in_seconds")

    @user_task_minimum_trigger_interval_in_seconds.setter
    def user_task_minimum_trigger_interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_minimum_trigger_interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @user_task_timeout_ms.setter
    def user_task_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_timeout_ms", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 catalog: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_retention_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 default_ddl_collation: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_public_schema_on_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_transient: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_data_extension_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication: Optional[pulumi.Input['DatabaseReplicationArgs']] = None,
                 storage_serialization_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[_builtins.str] catalog: The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the database.
        :param pulumi.Input[_builtins.int] data_retention_time_in_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        :param pulumi.Input[_builtins.str] default_ddl_collation: Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        :param pulumi.Input[_builtins.bool] drop_public_schema_on_creation: Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        :param pulumi.Input[_builtins.bool] enable_console_output: If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        :param pulumi.Input[_builtins.str] external_volume: The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.bool] is_transient: Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        :param pulumi.Input[_builtins.int] max_data_extension_time_in_days: Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        :param pulumi.Input['DatabaseReplicationArgs'] replication: Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        :param pulumi.Input[_builtins.str] storage_serialization_policy: The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds.
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_retention_time_in_days is not None:
            pulumi.set(__self__, "data_retention_time_in_days", data_retention_time_in_days)
        if default_ddl_collation is not None:
            pulumi.set(__self__, "default_ddl_collation", default_ddl_collation)
        if drop_public_schema_on_creation is not None:
            pulumi.set(__self__, "drop_public_schema_on_creation", drop_public_schema_on_creation)
        if enable_console_output is not None:
            pulumi.set(__self__, "enable_console_output", enable_console_output)
        if external_volume is not None:
            pulumi.set(__self__, "external_volume", external_volume)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if is_transient is not None:
            pulumi.set(__self__, "is_transient", is_transient)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if max_data_extension_time_in_days is not None:
            pulumi.set(__self__, "max_data_extension_time_in_days", max_data_extension_time_in_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quoted_identifiers_ignore_case is not None:
            pulumi.set(__self__, "quoted_identifiers_ignore_case", quoted_identifiers_ignore_case)
        if replace_invalid_characters is not None:
            pulumi.set(__self__, "replace_invalid_characters", replace_invalid_characters)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if storage_serialization_policy is not None:
            pulumi.set(__self__, "storage_serialization_policy", storage_serialization_policy)
        if suspend_task_after_num_failures is not None:
            pulumi.set(__self__, "suspend_task_after_num_failures", suspend_task_after_num_failures)
        if task_auto_retry_attempts is not None:
            pulumi.set(__self__, "task_auto_retry_attempts", task_auto_retry_attempts)
        if trace_level is not None:
            pulumi.set(__self__, "trace_level", trace_level)
        if user_task_managed_initial_warehouse_size is not None:
            pulumi.set(__self__, "user_task_managed_initial_warehouse_size", user_task_managed_initial_warehouse_size)
        if user_task_minimum_trigger_interval_in_seconds is not None:
            pulumi.set(__self__, "user_task_minimum_trigger_interval_in_seconds", user_task_minimum_trigger_interval_in_seconds)
        if user_task_timeout_ms is not None:
            pulumi.set(__self__, "user_task_timeout_ms", user_task_timeout_ms)

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="dataRetentionTimeInDays")
    def data_retention_time_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        """
        return pulumi.get(self, "data_retention_time_in_days")

    @data_retention_time_in_days.setter
    def data_retention_time_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "data_retention_time_in_days", value)

    @_builtins.property
    @pulumi.getter(name="defaultDdlCollation")
    def default_ddl_collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        """
        return pulumi.get(self, "default_ddl_collation")

    @default_ddl_collation.setter
    def default_ddl_collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ddl_collation", value)

    @_builtins.property
    @pulumi.getter(name="dropPublicSchemaOnCreation")
    def drop_public_schema_on_creation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        """
        return pulumi.get(self, "drop_public_schema_on_creation")

    @drop_public_schema_on_creation.setter
    def drop_public_schema_on_creation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drop_public_schema_on_creation", value)

    @_builtins.property
    @pulumi.getter(name="enableConsoleOutput")
    def enable_console_output(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        """
        return pulumi.get(self, "enable_console_output")

    @enable_console_output.setter
    def enable_console_output(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_console_output", value)

    @_builtins.property
    @pulumi.getter(name="externalVolume")
    def external_volume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        """
        return pulumi.get(self, "external_volume")

    @external_volume.setter
    def external_volume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_volume", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="isTransient")
    def is_transient(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        """
        return pulumi.get(self, "is_transient")

    @is_transient.setter
    def is_transient(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_transient", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter(name="maxDataExtensionTimeInDays")
    def max_data_extension_time_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        """
        return pulumi.get(self, "max_data_extension_time_in_days")

    @max_data_extension_time_in_days.setter
    def max_data_extension_time_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_data_extension_time_in_days", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="quotedIdentifiersIgnoreCase")
    def quoted_identifiers_ignore_case(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        """
        return pulumi.get(self, "quoted_identifiers_ignore_case")

    @quoted_identifiers_ignore_case.setter
    def quoted_identifiers_ignore_case(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "quoted_identifiers_ignore_case", value)

    @_builtins.property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @replace_invalid_characters.setter
    def replace_invalid_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace_invalid_characters", value)

    @_builtins.property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input['DatabaseReplicationArgs']]:
        """
        Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input['DatabaseReplicationArgs']]):
        pulumi.set(self, "replication", value)

    @_builtins.property
    @pulumi.getter(name="storageSerializationPolicy")
    def storage_serialization_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        """
        return pulumi.get(self, "storage_serialization_policy")

    @storage_serialization_policy.setter
    def storage_serialization_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_serialization_policy", value)

    @_builtins.property
    @pulumi.getter(name="suspendTaskAfterNumFailures")
    def suspend_task_after_num_failures(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        """
        return pulumi.get(self, "suspend_task_after_num_failures")

    @suspend_task_after_num_failures.setter
    def suspend_task_after_num_failures(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_task_after_num_failures", value)

    @_builtins.property
    @pulumi.getter(name="taskAutoRetryAttempts")
    def task_auto_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        """
        return pulumi.get(self, "task_auto_retry_attempts")

    @task_auto_retry_attempts.setter
    def task_auto_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "task_auto_retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        """
        return pulumi.get(self, "trace_level")

    @trace_level.setter
    def trace_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trace_level", value)

    @_builtins.property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @user_task_managed_initial_warehouse_size.setter
    def user_task_managed_initial_warehouse_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_task_managed_initial_warehouse_size", value)

    @_builtins.property
    @pulumi.getter(name="userTaskMinimumTriggerIntervalInSeconds")
    def user_task_minimum_trigger_interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum amount of time between Triggered Task executions in seconds.
        """
        return pulumi.get(self, "user_task_minimum_trigger_interval_in_seconds")

    @user_task_minimum_trigger_interval_in_seconds.setter
    def user_task_minimum_trigger_interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_minimum_trigger_interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        return pulumi.get(self, "user_task_timeout_ms")

    @user_task_timeout_ms.setter
    def user_task_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_task_timeout_ms", value)


@pulumi.type_token("snowflake:index/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_retention_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 default_ddl_collation: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_public_schema_on_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 is_transient: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_data_extension_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication: Optional[pulumi.Input[Union['DatabaseReplicationArgs', 'DatabaseReplicationArgsDict']]] = None,
                 storage_serialization_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        Make sure that `is_transient` and `with_managed_access` are set in your config explicitly before import to avoid diff and recreation

        (reasons are presented in this migration guide entry).

        ```sh
        $ pulumi import snowflake:index/database:Database example '"<database_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog: The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the database.
        :param pulumi.Input[_builtins.int] data_retention_time_in_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        :param pulumi.Input[_builtins.str] default_ddl_collation: Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        :param pulumi.Input[_builtins.bool] drop_public_schema_on_creation: Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        :param pulumi.Input[_builtins.bool] enable_console_output: If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        :param pulumi.Input[_builtins.str] external_volume: The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        :param pulumi.Input[_builtins.bool] is_transient: Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        :param pulumi.Input[_builtins.int] max_data_extension_time_in_days: Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        :param pulumi.Input[Union['DatabaseReplicationArgs', 'DatabaseReplicationArgsDict']] replication: Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        :param pulumi.Input[_builtins.str] storage_serialization_policy: The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds.
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatabaseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Make sure that `is_transient` and `with_managed_access` are set in your config explicitly before import to avoid diff and recreation

        (reasons are presented in this migration guide entry).

        ```sh
        $ pulumi import snowflake:index/database:Database example '"<database_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 data_retention_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 default_ddl_collation: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_public_schema_on_creation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 is_transient: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 max_data_extension_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication: Optional[pulumi.Input[Union['DatabaseReplicationArgs', 'DatabaseReplicationArgsDict']]] = None,
                 storage_serialization_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
                 task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 trace_level: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
                 user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["catalog"] = catalog
            __props__.__dict__["comment"] = comment
            __props__.__dict__["data_retention_time_in_days"] = data_retention_time_in_days
            __props__.__dict__["default_ddl_collation"] = default_ddl_collation
            __props__.__dict__["drop_public_schema_on_creation"] = drop_public_schema_on_creation
            __props__.__dict__["enable_console_output"] = enable_console_output
            __props__.__dict__["external_volume"] = external_volume
            __props__.__dict__["is_transient"] = is_transient
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["max_data_extension_time_in_days"] = max_data_extension_time_in_days
            __props__.__dict__["name"] = name
            __props__.__dict__["quoted_identifiers_ignore_case"] = quoted_identifiers_ignore_case
            __props__.__dict__["replace_invalid_characters"] = replace_invalid_characters
            __props__.__dict__["replication"] = replication
            __props__.__dict__["storage_serialization_policy"] = storage_serialization_policy
            __props__.__dict__["suspend_task_after_num_failures"] = suspend_task_after_num_failures
            __props__.__dict__["task_auto_retry_attempts"] = task_auto_retry_attempts
            __props__.__dict__["trace_level"] = trace_level
            __props__.__dict__["user_task_managed_initial_warehouse_size"] = user_task_managed_initial_warehouse_size
            __props__.__dict__["user_task_minimum_trigger_interval_in_seconds"] = user_task_minimum_trigger_interval_in_seconds
            __props__.__dict__["user_task_timeout_ms"] = user_task_timeout_ms
            __props__.__dict__["fully_qualified_name"] = None
        super(Database, __self__).__init__(
            'snowflake:index/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            data_retention_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            default_ddl_collation: Optional[pulumi.Input[_builtins.str]] = None,
            drop_public_schema_on_creation: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_console_output: Optional[pulumi.Input[_builtins.bool]] = None,
            external_volume: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_transient: Optional[pulumi.Input[_builtins.bool]] = None,
            log_level: Optional[pulumi.Input[_builtins.str]] = None,
            max_data_extension_time_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            quoted_identifiers_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
            replace_invalid_characters: Optional[pulumi.Input[_builtins.bool]] = None,
            replication: Optional[pulumi.Input[Union['DatabaseReplicationArgs', 'DatabaseReplicationArgsDict']]] = None,
            storage_serialization_policy: Optional[pulumi.Input[_builtins.str]] = None,
            suspend_task_after_num_failures: Optional[pulumi.Input[_builtins.int]] = None,
            task_auto_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            trace_level: Optional[pulumi.Input[_builtins.str]] = None,
            user_task_managed_initial_warehouse_size: Optional[pulumi.Input[_builtins.str]] = None,
            user_task_minimum_trigger_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            user_task_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog: The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the database.
        :param pulumi.Input[_builtins.int] data_retention_time_in_days: Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        :param pulumi.Input[_builtins.str] default_ddl_collation: Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        :param pulumi.Input[_builtins.bool] drop_public_schema_on_creation: Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        :param pulumi.Input[_builtins.bool] enable_console_output: If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        :param pulumi.Input[_builtins.str] external_volume: The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.bool] is_transient: Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        :param pulumi.Input[_builtins.str] log_level: Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        :param pulumi.Input[_builtins.int] max_data_extension_time_in_days: Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.bool] quoted_identifiers_ignore_case: If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        :param pulumi.Input[_builtins.bool] replace_invalid_characters: Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        :param pulumi.Input[Union['DatabaseReplicationArgs', 'DatabaseReplicationArgsDict']] replication: Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        :param pulumi.Input[_builtins.str] storage_serialization_policy: The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        :param pulumi.Input[_builtins.int] suspend_task_after_num_failures: How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        :param pulumi.Input[_builtins.int] task_auto_retry_attempts: Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        :param pulumi.Input[_builtins.str] trace_level: Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        :param pulumi.Input[_builtins.str] user_task_managed_initial_warehouse_size: The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        :param pulumi.Input[_builtins.int] user_task_minimum_trigger_interval_in_seconds: Minimum amount of time between Triggered Task executions in seconds.
        :param pulumi.Input[_builtins.int] user_task_timeout_ms: User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["catalog"] = catalog
        __props__.__dict__["comment"] = comment
        __props__.__dict__["data_retention_time_in_days"] = data_retention_time_in_days
        __props__.__dict__["default_ddl_collation"] = default_ddl_collation
        __props__.__dict__["drop_public_schema_on_creation"] = drop_public_schema_on_creation
        __props__.__dict__["enable_console_output"] = enable_console_output
        __props__.__dict__["external_volume"] = external_volume
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["is_transient"] = is_transient
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["max_data_extension_time_in_days"] = max_data_extension_time_in_days
        __props__.__dict__["name"] = name
        __props__.__dict__["quoted_identifiers_ignore_case"] = quoted_identifiers_ignore_case
        __props__.__dict__["replace_invalid_characters"] = replace_invalid_characters
        __props__.__dict__["replication"] = replication
        __props__.__dict__["storage_serialization_policy"] = storage_serialization_policy
        __props__.__dict__["suspend_task_after_num_failures"] = suspend_task_after_num_failures
        __props__.__dict__["task_auto_retry_attempts"] = task_auto_retry_attempts
        __props__.__dict__["trace_level"] = trace_level
        __props__.__dict__["user_task_managed_initial_warehouse_size"] = user_task_managed_initial_warehouse_size
        __props__.__dict__["user_task_minimum_trigger_interval_in_seconds"] = user_task_minimum_trigger_interval_in_seconds
        __props__.__dict__["user_task_timeout_ms"] = user_task_timeout_ms
        return Database(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def catalog(self) -> pulumi.Output[_builtins.str]:
        """
        The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
        """
        return pulumi.get(self, "catalog")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the database.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="dataRetentionTimeInDays")
    def data_retention_time_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
        """
        return pulumi.get(self, "data_retention_time_in_days")

    @_builtins.property
    @pulumi.getter(name="defaultDdlCollation")
    def default_ddl_collation(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
        """
        return pulumi.get(self, "default_ddl_collation")

    @_builtins.property
    @pulumi.getter(name="dropPublicSchemaOnCreation")
    def drop_public_schema_on_creation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to drop public schema on creation or not. Modifying the parameter after database is already created won't have any effect.
        """
        return pulumi.get(self, "drop_public_schema_on_creation")

    @_builtins.property
    @pulumi.getter(name="enableConsoleOutput")
    def enable_console_output(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, enables stdout/stderr fast path logging for anonymous stored procedures.
        """
        return pulumi.get(self, "enable_console_output")

    @_builtins.property
    @pulumi.getter(name="externalVolume")
    def external_volume(self) -> pulumi.Output[_builtins.str]:
        """
        The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
        """
        return pulumi.get(self, "external_volume")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="isTransient")
    def is_transient(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
        """
        return pulumi.get(self, "is_transient")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter(name="maxDataExtensionTimeInDays")
    def max_data_extension_time_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX*DATA*EXTENSION*TIME*IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
        """
        return pulumi.get(self, "max_data_extension_time_in_days")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '\\n\\n.\\n\\n.\\n\\n') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="quotedIdentifiersIgnoreCase")
    def quoted_identifiers_ignore_case(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the case of quoted identifiers is ignored. For more information, see [QUOTED*IDENTIFIERS*IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
        """
        return pulumi.get(self, "quoted_identifiers_ignore_case")

    @_builtins.property
    @pulumi.getter(name="replaceInvalidCharacters")
    def replace_invalid_characters(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE*INVALID*CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
        """
        return pulumi.get(self, "replace_invalid_characters")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> pulumi.Output[Optional['outputs.DatabaseReplication']]:
        """
        Configures replication for a given database. When specified, this database will be promoted to serve as a primary database for replication. A primary database can be replicated in one or more accounts, allowing users in those accounts to query objects in each secondary (i.e. replica) database.
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter(name="storageSerializationPolicy")
    def storage_serialization_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE*SERIALIZATION*POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
        """
        return pulumi.get(self, "storage_serialization_policy")

    @_builtins.property
    @pulumi.getter(name="suspendTaskAfterNumFailures")
    def suspend_task_after_num_failures(self) -> pulumi.Output[_builtins.int]:
        """
        How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND*TASK*AFTER*NUM*FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
        """
        return pulumi.get(self, "suspend_task_after_num_failures")

    @_builtins.property
    @pulumi.getter(name="taskAutoRetryAttempts")
    def task_auto_retry_attempts(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum automatic retries allowed for a user task. For more information, see [TASK*AUTO*RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
        """
        return pulumi.get(self, "task_auto_retry_attempts")

    @_builtins.property
    @pulumi.getter(name="traceLevel")
    def trace_level(self) -> pulumi.Output[_builtins.str]:
        """
        Controls how trace events are ingested into the event table. Valid options are: `ALWAYS` | `ON_EVENT` | `PROPAGATE` | `OFF`. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
        """
        return pulumi.get(self, "trace_level")

    @_builtins.property
    @pulumi.getter(name="userTaskManagedInitialWarehouseSize")
    def user_task_managed_initial_warehouse_size(self) -> pulumi.Output[_builtins.str]:
        """
        The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER*TASK*MANAGED*INITIAL*WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
        """
        return pulumi.get(self, "user_task_managed_initial_warehouse_size")

    @_builtins.property
    @pulumi.getter(name="userTaskMinimumTriggerIntervalInSeconds")
    def user_task_minimum_trigger_interval_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum amount of time between Triggered Task executions in seconds.
        """
        return pulumi.get(self, "user_task_minimum_trigger_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="userTaskTimeoutMs")
    def user_task_timeout_ms(self) -> pulumi.Output[_builtins.int]:
        """
        User task execution timeout in milliseconds. For more information, see [USER*TASK*TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
        """
        return pulumi.get(self, "user_task_timeout_ms")

