# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkPolicyArgs', 'NetworkPolicy']

@pulumi.input_type
class NetworkPolicyArgs:
    def __init__(__self__, *,
                 allowed_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the network policy.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        if allowed_ip_lists is not None:
            pulumi.set(__self__, "allowed_ip_lists", allowed_ip_lists)
        if allowed_network_rule_lists is not None:
            pulumi.set(__self__, "allowed_network_rule_lists", allowed_network_rule_lists)
        if blocked_ip_lists is not None:
            pulumi.set(__self__, "blocked_ip_lists", blocked_ip_lists)
        if blocked_network_rule_lists is not None:
            pulumi.set(__self__, "blocked_network_rule_lists", blocked_network_rule_lists)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="allowedIpLists")
    def allowed_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        """
        return pulumi.get(self, "allowed_ip_lists")

    @allowed_ip_lists.setter
    def allowed_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="allowedNetworkRuleLists")
    def allowed_network_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        """
        return pulumi.get(self, "allowed_network_rule_lists")

    @allowed_network_rule_lists.setter
    def allowed_network_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_network_rule_lists", value)

    @_builtins.property
    @pulumi.getter(name="blockedIpLists")
    def blocked_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        """
        return pulumi.get(self, "blocked_ip_lists")

    @blocked_ip_lists.setter
    def blocked_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="blockedNetworkRuleLists")
    def blocked_network_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        """
        return pulumi.get(self, "blocked_network_rule_lists")

    @blocked_network_rule_lists.setter
    def blocked_network_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_network_rule_lists", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the network policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkPolicyState:
    def __init__(__self__, *,
                 allowed_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyDescribeOutputArgs']]]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering NetworkPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the network policy.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE NETWORK POLICY` for the given network policy.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyShowOutputArgs']]] show_outputs: Outputs the result of `SHOW NETWORK POLICIES` for the given network policy.
        """
        if allowed_ip_lists is not None:
            pulumi.set(__self__, "allowed_ip_lists", allowed_ip_lists)
        if allowed_network_rule_lists is not None:
            pulumi.set(__self__, "allowed_network_rule_lists", allowed_network_rule_lists)
        if blocked_ip_lists is not None:
            pulumi.set(__self__, "blocked_ip_lists", blocked_ip_lists)
        if blocked_network_rule_lists is not None:
            pulumi.set(__self__, "blocked_network_rule_lists", blocked_network_rule_lists)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="allowedIpLists")
    def allowed_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        """
        return pulumi.get(self, "allowed_ip_lists")

    @allowed_ip_lists.setter
    def allowed_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="allowedNetworkRuleLists")
    def allowed_network_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        """
        return pulumi.get(self, "allowed_network_rule_lists")

    @allowed_network_rule_lists.setter
    def allowed_network_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_network_rule_lists", value)

    @_builtins.property
    @pulumi.getter(name="blockedIpLists")
    def blocked_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        """
        return pulumi.get(self, "blocked_ip_lists")

    @blocked_ip_lists.setter
    def blocked_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="blockedNetworkRuleLists")
    def blocked_network_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        """
        return pulumi.get(self, "blocked_network_rule_lists")

    @blocked_network_rule_lists.setter
    def blocked_network_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_network_rule_lists", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the network policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE NETWORK POLICY` for the given network policy.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW NETWORK POLICIES` for the given network policy.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/networkPolicy:NetworkPolicy")
class NetworkPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/networkPolicy:NetworkPolicy example '"<network_policy_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the network policy.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/networkPolicy:NetworkPolicy example '"<network_policy_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param NetworkPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blocked_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPolicyArgs.__new__(NetworkPolicyArgs)

            __props__.__dict__["allowed_ip_lists"] = allowed_ip_lists
            __props__.__dict__["allowed_network_rule_lists"] = allowed_network_rule_lists
            __props__.__dict__["blocked_ip_lists"] = blocked_ip_lists
            __props__.__dict__["blocked_network_rule_lists"] = blocked_network_rule_lists
            __props__.__dict__["comment"] = comment
            __props__.__dict__["name"] = name
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(NetworkPolicy, __self__).__init__(
            'snowflake:index/networkPolicy:NetworkPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            blocked_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            blocked_network_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyDescribeOutputArgs', 'NetworkPolicyDescribeOutputArgsDict']]]]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyShowOutputArgs', 'NetworkPolicyShowOutputArgsDict']]]]] = None) -> 'NetworkPolicy':
        """
        Get an existing NetworkPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_ip_lists: Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_network_rule_lists: Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the network policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyDescribeOutputArgs', 'NetworkPolicyDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE NETWORK POLICY` for the given network policy.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkPolicyShowOutputArgs', 'NetworkPolicyShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW NETWORK POLICIES` for the given network policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPolicyState.__new__(_NetworkPolicyState)

        __props__.__dict__["allowed_ip_lists"] = allowed_ip_lists
        __props__.__dict__["allowed_network_rule_lists"] = allowed_network_rule_lists
        __props__.__dict__["blocked_ip_lists"] = blocked_ip_lists
        __props__.__dict__["blocked_network_rule_lists"] = blocked_network_rule_lists
        __props__.__dict__["comment"] = comment
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["show_outputs"] = show_outputs
        return NetworkPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedIpLists")
    def allowed_ip_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
        """
        return pulumi.get(self, "allowed_ip_lists")

    @_builtins.property
    @pulumi.getter(name="allowedNetworkRuleLists")
    def allowed_network_rule_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake. For more information about this resource, see docs.
        """
        return pulumi.get(self, "allowed_network_rule_lists")

    @_builtins.property
    @pulumi.getter(name="blockedIpLists")
    def blocked_ip_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
        """
        return pulumi.get(self, "blocked_ip_lists")

    @_builtins.property
    @pulumi.getter(name="blockedNetworkRuleLists")
    def blocked_network_rule_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake. For more information about this resource, see docs.
        """
        return pulumi.get(self, "blocked_network_rule_lists")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the network policy.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.NetworkPolicyDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE NETWORK POLICY` for the given network policy.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.NetworkPolicyShowOutput']]:
        """
        Outputs the result of `SHOW NETWORK POLICIES` for the given network policy.
        """
        return pulumi.get(self, "show_outputs")

