# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NotificationIntegrationArgs', 'NotificationIntegration']

@pulumi.input_type
class NotificationIntegrationArgs:
    def __init__(__self__, *,
                 notification_provider: pulumi.Input[_builtins.str],
                 aws_sns_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_storage_queue_primary_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_pubsub_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_pubsub_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NotificationIntegration resource.
        :param pulumi.Input[_builtins.str] notification_provider: The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        :param pulumi.Input[_builtins.str] aws_sns_role_arn: AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        :param pulumi.Input[_builtins.str] aws_sns_topic_arn: AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        :param pulumi.Input[_builtins.str] aws_sqs_arn: AWS SQS queue ARN for notification integration to connect to
        :param pulumi.Input[_builtins.str] aws_sqs_role_arn: AWS IAM role ARN for notification integration to assume
        :param pulumi.Input[_builtins.str] azure_storage_queue_primary_uri: The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] azure_tenant_id: The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] comment: A comment for the integration
        :param pulumi.Input[_builtins.str] direction: Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        :param pulumi.Input[_builtins.bool] enabled: (Default: `true`)
        :param pulumi.Input[_builtins.str] gcp_pubsub_subscription_name: The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        :param pulumi.Input[_builtins.str] gcp_pubsub_topic_name: The topic id that Snowflake will use to push notifications.
        :param pulumi.Input[_builtins.str] type: (Default: `QUEUE`) A type of integration
        """
        pulumi.set(__self__, "notification_provider", notification_provider)
        if aws_sns_role_arn is not None:
            pulumi.set(__self__, "aws_sns_role_arn", aws_sns_role_arn)
        if aws_sns_topic_arn is not None:
            pulumi.set(__self__, "aws_sns_topic_arn", aws_sns_topic_arn)
        if aws_sqs_arn is not None:
            warnings.warn("""No longer supported notification method""", DeprecationWarning)
            pulumi.log.warn("""aws_sqs_arn is deprecated: No longer supported notification method""")
        if aws_sqs_arn is not None:
            pulumi.set(__self__, "aws_sqs_arn", aws_sqs_arn)
        if aws_sqs_role_arn is not None:
            warnings.warn("""No longer supported notification method""", DeprecationWarning)
            pulumi.log.warn("""aws_sqs_role_arn is deprecated: No longer supported notification method""")
        if aws_sqs_role_arn is not None:
            pulumi.set(__self__, "aws_sqs_role_arn", aws_sqs_role_arn)
        if azure_storage_queue_primary_uri is not None:
            pulumi.set(__self__, "azure_storage_queue_primary_uri", azure_storage_queue_primary_uri)
        if azure_tenant_id is not None:
            pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if direction is not None:
            warnings.warn("""Will be removed - it is added automatically on the SDK level.""", DeprecationWarning)
            pulumi.log.warn("""direction is deprecated: Will be removed - it is added automatically on the SDK level.""")
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if gcp_pubsub_subscription_name is not None:
            pulumi.set(__self__, "gcp_pubsub_subscription_name", gcp_pubsub_subscription_name)
        if gcp_pubsub_topic_name is not None:
            pulumi.set(__self__, "gcp_pubsub_topic_name", gcp_pubsub_topic_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            warnings.warn("""Will be removed - it is added automatically on the SDK level.""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Will be removed - it is added automatically on the SDK level.""")
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="notificationProvider")
    def notification_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        """
        return pulumi.get(self, "notification_provider")

    @notification_provider.setter
    def notification_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "notification_provider", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsRoleArn")
    def aws_sns_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        """
        return pulumi.get(self, "aws_sns_role_arn")

    @aws_sns_role_arn.setter
    def aws_sns_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsTopicArn")
    def aws_sns_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        """
        return pulumi.get(self, "aws_sns_topic_arn")

    @aws_sns_topic_arn.setter
    def aws_sns_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSqsArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS SQS queue ARN for notification integration to connect to
        """
        return pulumi.get(self, "aws_sqs_arn")

    @aws_sqs_arn.setter
    def aws_sqs_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sqs_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSqsRoleArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS IAM role ARN for notification integration to assume
        """
        return pulumi.get(self, "aws_sqs_role_arn")

    @aws_sqs_role_arn.setter
    def aws_sqs_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sqs_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="azureStorageQueuePrimaryUri")
    def azure_storage_queue_primary_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        """
        return pulumi.get(self, "azure_storage_queue_primary_uri")

    @azure_storage_queue_primary_uri.setter
    def azure_storage_queue_primary_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_storage_queue_primary_uri", value)

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        """
        return pulumi.get(self, "azure_tenant_id")

    @azure_tenant_id.setter
    def azure_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comment for the integration
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Will be removed - it is added automatically on the SDK level.""")
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="gcpPubsubSubscriptionName")
    def gcp_pubsub_subscription_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        """
        return pulumi.get(self, "gcp_pubsub_subscription_name")

    @gcp_pubsub_subscription_name.setter
    def gcp_pubsub_subscription_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_pubsub_subscription_name", value)

    @_builtins.property
    @pulumi.getter(name="gcpPubsubTopicName")
    def gcp_pubsub_topic_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The topic id that Snowflake will use to push notifications.
        """
        return pulumi.get(self, "gcp_pubsub_topic_name")

    @gcp_pubsub_topic_name.setter
    def gcp_pubsub_topic_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_pubsub_topic_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Will be removed - it is added automatically on the SDK level.""")
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `QUEUE`) A type of integration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _NotificationIntegrationState:
    def __init__(__self__, *,
                 aws_sns_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sns_iam_user_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sns_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_iam_user_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_storage_queue_primary_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_pubsub_service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_pubsub_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_pubsub_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NotificationIntegration resources.
        :param pulumi.Input[_builtins.str] aws_sns_external_id: The external ID that Snowflake will use when assuming the AWS role
        :param pulumi.Input[_builtins.str] aws_sns_iam_user_arn: The Snowflake user that will attempt to assume the AWS role.
        :param pulumi.Input[_builtins.str] aws_sns_role_arn: AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        :param pulumi.Input[_builtins.str] aws_sns_topic_arn: AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        :param pulumi.Input[_builtins.str] aws_sqs_arn: AWS SQS queue ARN for notification integration to connect to
        :param pulumi.Input[_builtins.str] aws_sqs_external_id: The external ID that Snowflake will use when assuming the AWS role
        :param pulumi.Input[_builtins.str] aws_sqs_iam_user_arn: The Snowflake user that will attempt to assume the AWS role.
        :param pulumi.Input[_builtins.str] aws_sqs_role_arn: AWS IAM role ARN for notification integration to assume
        :param pulumi.Input[_builtins.str] azure_storage_queue_primary_uri: The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] azure_tenant_id: The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] comment: A comment for the integration
        :param pulumi.Input[_builtins.str] created_on: Date and time when the notification integration was created.
        :param pulumi.Input[_builtins.str] direction: Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        :param pulumi.Input[_builtins.bool] enabled: (Default: `true`)
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] gcp_pubsub_service_account: The GCP service account identifier that Snowflake will use when assuming the GCP role
        :param pulumi.Input[_builtins.str] gcp_pubsub_subscription_name: The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        :param pulumi.Input[_builtins.str] gcp_pubsub_topic_name: The topic id that Snowflake will use to push notifications.
        :param pulumi.Input[_builtins.str] notification_provider: The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        :param pulumi.Input[_builtins.str] type: (Default: `QUEUE`) A type of integration
        """
        if aws_sns_external_id is not None:
            pulumi.set(__self__, "aws_sns_external_id", aws_sns_external_id)
        if aws_sns_iam_user_arn is not None:
            pulumi.set(__self__, "aws_sns_iam_user_arn", aws_sns_iam_user_arn)
        if aws_sns_role_arn is not None:
            pulumi.set(__self__, "aws_sns_role_arn", aws_sns_role_arn)
        if aws_sns_topic_arn is not None:
            pulumi.set(__self__, "aws_sns_topic_arn", aws_sns_topic_arn)
        if aws_sqs_arn is not None:
            warnings.warn("""No longer supported notification method""", DeprecationWarning)
            pulumi.log.warn("""aws_sqs_arn is deprecated: No longer supported notification method""")
        if aws_sqs_arn is not None:
            pulumi.set(__self__, "aws_sqs_arn", aws_sqs_arn)
        if aws_sqs_external_id is not None:
            warnings.warn("""No longer supported notification method""", DeprecationWarning)
            pulumi.log.warn("""aws_sqs_external_id is deprecated: No longer supported notification method""")
        if aws_sqs_external_id is not None:
            pulumi.set(__self__, "aws_sqs_external_id", aws_sqs_external_id)
        if aws_sqs_iam_user_arn is not None:
            warnings.warn("""No longer supported notification method""", DeprecationWarning)
            pulumi.log.warn("""aws_sqs_iam_user_arn is deprecated: No longer supported notification method""")
        if aws_sqs_iam_user_arn is not None:
            pulumi.set(__self__, "aws_sqs_iam_user_arn", aws_sqs_iam_user_arn)
        if aws_sqs_role_arn is not None:
            warnings.warn("""No longer supported notification method""", DeprecationWarning)
            pulumi.log.warn("""aws_sqs_role_arn is deprecated: No longer supported notification method""")
        if aws_sqs_role_arn is not None:
            pulumi.set(__self__, "aws_sqs_role_arn", aws_sqs_role_arn)
        if azure_storage_queue_primary_uri is not None:
            pulumi.set(__self__, "azure_storage_queue_primary_uri", azure_storage_queue_primary_uri)
        if azure_tenant_id is not None:
            pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if direction is not None:
            warnings.warn("""Will be removed - it is added automatically on the SDK level.""", DeprecationWarning)
            pulumi.log.warn("""direction is deprecated: Will be removed - it is added automatically on the SDK level.""")
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if gcp_pubsub_service_account is not None:
            pulumi.set(__self__, "gcp_pubsub_service_account", gcp_pubsub_service_account)
        if gcp_pubsub_subscription_name is not None:
            pulumi.set(__self__, "gcp_pubsub_subscription_name", gcp_pubsub_subscription_name)
        if gcp_pubsub_topic_name is not None:
            pulumi.set(__self__, "gcp_pubsub_topic_name", gcp_pubsub_topic_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_provider is not None:
            pulumi.set(__self__, "notification_provider", notification_provider)
        if type is not None:
            warnings.warn("""Will be removed - it is added automatically on the SDK level.""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Will be removed - it is added automatically on the SDK level.""")
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="awsSnsExternalId")
    def aws_sns_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external ID that Snowflake will use when assuming the AWS role
        """
        return pulumi.get(self, "aws_sns_external_id")

    @aws_sns_external_id.setter
    def aws_sns_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_external_id", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsIamUserArn")
    def aws_sns_iam_user_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Snowflake user that will attempt to assume the AWS role.
        """
        return pulumi.get(self, "aws_sns_iam_user_arn")

    @aws_sns_iam_user_arn.setter
    def aws_sns_iam_user_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_iam_user_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsRoleArn")
    def aws_sns_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        """
        return pulumi.get(self, "aws_sns_role_arn")

    @aws_sns_role_arn.setter
    def aws_sns_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSnsTopicArn")
    def aws_sns_topic_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        """
        return pulumi.get(self, "aws_sns_topic_arn")

    @aws_sns_topic_arn.setter
    def aws_sns_topic_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sns_topic_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSqsArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS SQS queue ARN for notification integration to connect to
        """
        return pulumi.get(self, "aws_sqs_arn")

    @aws_sqs_arn.setter
    def aws_sqs_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sqs_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSqsExternalId")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external ID that Snowflake will use when assuming the AWS role
        """
        return pulumi.get(self, "aws_sqs_external_id")

    @aws_sqs_external_id.setter
    def aws_sqs_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sqs_external_id", value)

    @_builtins.property
    @pulumi.getter(name="awsSqsIamUserArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_iam_user_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Snowflake user that will attempt to assume the AWS role.
        """
        return pulumi.get(self, "aws_sqs_iam_user_arn")

    @aws_sqs_iam_user_arn.setter
    def aws_sqs_iam_user_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sqs_iam_user_arn", value)

    @_builtins.property
    @pulumi.getter(name="awsSqsRoleArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS IAM role ARN for notification integration to assume
        """
        return pulumi.get(self, "aws_sqs_role_arn")

    @aws_sqs_role_arn.setter
    def aws_sqs_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_sqs_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="azureStorageQueuePrimaryUri")
    def azure_storage_queue_primary_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        """
        return pulumi.get(self, "azure_storage_queue_primary_uri")

    @azure_storage_queue_primary_uri.setter
    def azure_storage_queue_primary_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_storage_queue_primary_uri", value)

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        """
        return pulumi.get(self, "azure_tenant_id")

    @azure_tenant_id.setter
    def azure_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comment for the integration
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time when the notification integration was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Will be removed - it is added automatically on the SDK level.""")
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `true`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="gcpPubsubServiceAccount")
    def gcp_pubsub_service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP service account identifier that Snowflake will use when assuming the GCP role
        """
        return pulumi.get(self, "gcp_pubsub_service_account")

    @gcp_pubsub_service_account.setter
    def gcp_pubsub_service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_pubsub_service_account", value)

    @_builtins.property
    @pulumi.getter(name="gcpPubsubSubscriptionName")
    def gcp_pubsub_subscription_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        """
        return pulumi.get(self, "gcp_pubsub_subscription_name")

    @gcp_pubsub_subscription_name.setter
    def gcp_pubsub_subscription_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_pubsub_subscription_name", value)

    @_builtins.property
    @pulumi.getter(name="gcpPubsubTopicName")
    def gcp_pubsub_topic_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The topic id that Snowflake will use to push notifications.
        """
        return pulumi.get(self, "gcp_pubsub_topic_name")

    @gcp_pubsub_topic_name.setter
    def gcp_pubsub_topic_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_pubsub_topic_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationProvider")
    def notification_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        """
        return pulumi.get(self, "notification_provider")

    @notification_provider.setter
    def notification_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_provider", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Will be removed - it is added automatically on the SDK level.""")
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: `QUEUE`) A type of integration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("snowflake:index/notificationIntegration:NotificationIntegration")
class NotificationIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_sns_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_storage_queue_primary_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_pubsub_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_pubsub_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/notificationIntegration:NotificationIntegration example name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_sns_role_arn: AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        :param pulumi.Input[_builtins.str] aws_sns_topic_arn: AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        :param pulumi.Input[_builtins.str] aws_sqs_arn: AWS SQS queue ARN for notification integration to connect to
        :param pulumi.Input[_builtins.str] aws_sqs_role_arn: AWS IAM role ARN for notification integration to assume
        :param pulumi.Input[_builtins.str] azure_storage_queue_primary_uri: The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] azure_tenant_id: The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] comment: A comment for the integration
        :param pulumi.Input[_builtins.str] direction: Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        :param pulumi.Input[_builtins.bool] enabled: (Default: `true`)
        :param pulumi.Input[_builtins.str] gcp_pubsub_subscription_name: The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        :param pulumi.Input[_builtins.str] gcp_pubsub_topic_name: The topic id that Snowflake will use to push notifications.
        :param pulumi.Input[_builtins.str] notification_provider: The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        :param pulumi.Input[_builtins.str] type: (Default: `QUEUE`) A type of integration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/notificationIntegration:NotificationIntegration example name
        ```

        :param str resource_name: The name of the resource.
        :param NotificationIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_sns_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 aws_sqs_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_storage_queue_primary_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_pubsub_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcp_pubsub_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationIntegrationArgs.__new__(NotificationIntegrationArgs)

            __props__.__dict__["aws_sns_role_arn"] = aws_sns_role_arn
            __props__.__dict__["aws_sns_topic_arn"] = aws_sns_topic_arn
            __props__.__dict__["aws_sqs_arn"] = aws_sqs_arn
            __props__.__dict__["aws_sqs_role_arn"] = aws_sqs_role_arn
            __props__.__dict__["azure_storage_queue_primary_uri"] = azure_storage_queue_primary_uri
            __props__.__dict__["azure_tenant_id"] = azure_tenant_id
            __props__.__dict__["comment"] = comment
            __props__.__dict__["direction"] = direction
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["gcp_pubsub_subscription_name"] = gcp_pubsub_subscription_name
            __props__.__dict__["gcp_pubsub_topic_name"] = gcp_pubsub_topic_name
            __props__.__dict__["name"] = name
            if notification_provider is None and not opts.urn:
                raise TypeError("Missing required property 'notification_provider'")
            __props__.__dict__["notification_provider"] = notification_provider
            __props__.__dict__["type"] = type
            __props__.__dict__["aws_sns_external_id"] = None
            __props__.__dict__["aws_sns_iam_user_arn"] = None
            __props__.__dict__["aws_sqs_external_id"] = None
            __props__.__dict__["aws_sqs_iam_user_arn"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["gcp_pubsub_service_account"] = None
        super(NotificationIntegration, __self__).__init__(
            'snowflake:index/notificationIntegration:NotificationIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_sns_external_id: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sns_iam_user_arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sns_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sns_topic_arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sqs_arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sqs_external_id: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sqs_iam_user_arn: Optional[pulumi.Input[_builtins.str]] = None,
            aws_sqs_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            azure_storage_queue_primary_uri: Optional[pulumi.Input[_builtins.str]] = None,
            azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_pubsub_service_account: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_pubsub_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
            gcp_pubsub_topic_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_provider: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NotificationIntegration':
        """
        Get an existing NotificationIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_sns_external_id: The external ID that Snowflake will use when assuming the AWS role
        :param pulumi.Input[_builtins.str] aws_sns_iam_user_arn: The Snowflake user that will attempt to assume the AWS role.
        :param pulumi.Input[_builtins.str] aws_sns_role_arn: AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        :param pulumi.Input[_builtins.str] aws_sns_topic_arn: AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        :param pulumi.Input[_builtins.str] aws_sqs_arn: AWS SQS queue ARN for notification integration to connect to
        :param pulumi.Input[_builtins.str] aws_sqs_external_id: The external ID that Snowflake will use when assuming the AWS role
        :param pulumi.Input[_builtins.str] aws_sqs_iam_user_arn: The Snowflake user that will attempt to assume the AWS role.
        :param pulumi.Input[_builtins.str] aws_sqs_role_arn: AWS IAM role ARN for notification integration to assume
        :param pulumi.Input[_builtins.str] azure_storage_queue_primary_uri: The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] azure_tenant_id: The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        :param pulumi.Input[_builtins.str] comment: A comment for the integration
        :param pulumi.Input[_builtins.str] created_on: Date and time when the notification integration was created.
        :param pulumi.Input[_builtins.str] direction: Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        :param pulumi.Input[_builtins.bool] enabled: (Default: `true`)
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] gcp_pubsub_service_account: The GCP service account identifier that Snowflake will use when assuming the GCP role
        :param pulumi.Input[_builtins.str] gcp_pubsub_subscription_name: The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        :param pulumi.Input[_builtins.str] gcp_pubsub_topic_name: The topic id that Snowflake will use to push notifications.
        :param pulumi.Input[_builtins.str] notification_provider: The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        :param pulumi.Input[_builtins.str] type: (Default: `QUEUE`) A type of integration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationIntegrationState.__new__(_NotificationIntegrationState)

        __props__.__dict__["aws_sns_external_id"] = aws_sns_external_id
        __props__.__dict__["aws_sns_iam_user_arn"] = aws_sns_iam_user_arn
        __props__.__dict__["aws_sns_role_arn"] = aws_sns_role_arn
        __props__.__dict__["aws_sns_topic_arn"] = aws_sns_topic_arn
        __props__.__dict__["aws_sqs_arn"] = aws_sqs_arn
        __props__.__dict__["aws_sqs_external_id"] = aws_sqs_external_id
        __props__.__dict__["aws_sqs_iam_user_arn"] = aws_sqs_iam_user_arn
        __props__.__dict__["aws_sqs_role_arn"] = aws_sqs_role_arn
        __props__.__dict__["azure_storage_queue_primary_uri"] = azure_storage_queue_primary_uri
        __props__.__dict__["azure_tenant_id"] = azure_tenant_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["direction"] = direction
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["gcp_pubsub_service_account"] = gcp_pubsub_service_account
        __props__.__dict__["gcp_pubsub_subscription_name"] = gcp_pubsub_subscription_name
        __props__.__dict__["gcp_pubsub_topic_name"] = gcp_pubsub_topic_name
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_provider"] = notification_provider
        __props__.__dict__["type"] = type
        return NotificationIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsSnsExternalId")
    def aws_sns_external_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external ID that Snowflake will use when assuming the AWS role
        """
        return pulumi.get(self, "aws_sns_external_id")

    @_builtins.property
    @pulumi.getter(name="awsSnsIamUserArn")
    def aws_sns_iam_user_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Snowflake user that will attempt to assume the AWS role.
        """
        return pulumi.get(self, "aws_sns_iam_user_arn")

    @_builtins.property
    @pulumi.getter(name="awsSnsRoleArn")
    def aws_sns_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS IAM role ARN for notification integration to assume. Required for AWS_SNS provider
        """
        return pulumi.get(self, "aws_sns_role_arn")

    @_builtins.property
    @pulumi.getter(name="awsSnsTopicArn")
    def aws_sns_topic_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS SNS Topic ARN for notification integration to connect to. Required for AWS_SNS provider.
        """
        return pulumi.get(self, "aws_sns_topic_arn")

    @_builtins.property
    @pulumi.getter(name="awsSqsArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS SQS queue ARN for notification integration to connect to
        """
        return pulumi.get(self, "aws_sqs_arn")

    @_builtins.property
    @pulumi.getter(name="awsSqsExternalId")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_external_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external ID that Snowflake will use when assuming the AWS role
        """
        return pulumi.get(self, "aws_sqs_external_id")

    @_builtins.property
    @pulumi.getter(name="awsSqsIamUserArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_iam_user_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Snowflake user that will attempt to assume the AWS role.
        """
        return pulumi.get(self, "aws_sqs_iam_user_arn")

    @_builtins.property
    @pulumi.getter(name="awsSqsRoleArn")
    @_utilities.deprecated("""No longer supported notification method""")
    def aws_sqs_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS IAM role ARN for notification integration to assume
        """
        return pulumi.get(self, "aws_sqs_role_arn")

    @_builtins.property
    @pulumi.getter(name="azureStorageQueuePrimaryUri")
    def azure_storage_queue_primary_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The queue ID for the Azure Queue Storage queue created for Event Grid notifications. Required for AZURE*STORAGE*QUEUE provider
        """
        return pulumi.get(self, "azure_storage_queue_primary_uri")

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Azure Active Directory tenant used for identity management. Required for AZURE*STORAGE*QUEUE provider
        """
        return pulumi.get(self, "azure_tenant_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A comment for the integration
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time when the notification integration was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Will be removed - it is added automatically on the SDK level.""")
    def direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `true`)
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="gcpPubsubServiceAccount")
    def gcp_pubsub_service_account(self) -> pulumi.Output[_builtins.str]:
        """
        The GCP service account identifier that Snowflake will use when assuming the GCP role
        """
        return pulumi.get(self, "gcp_pubsub_service_account")

    @_builtins.property
    @pulumi.getter(name="gcpPubsubSubscriptionName")
    def gcp_pubsub_subscription_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
        """
        return pulumi.get(self, "gcp_pubsub_subscription_name")

    @_builtins.property
    @pulumi.getter(name="gcpPubsubTopicName")
    def gcp_pubsub_topic_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The topic id that Snowflake will use to push notifications.
        """
        return pulumi.get(self, "gcp_pubsub_topic_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationProvider")
    def notification_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The third-party cloud message queuing service (supported values: AZURE*STORAGE*QUEUE, AWS*SNS, GCP*PUBSUB; AWS_SQS is deprecated and will be removed in the future provider versions)
        """
        return pulumi.get(self, "notification_provider")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Will be removed - it is added automatically on the SDK level.""")
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: `QUEUE`) A type of integration
        """
        return pulumi.get(self, "type")

