# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PasswordPolicyArgs', 'PasswordPolicy']

@pulumi.input_type
class PasswordPolicyArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 history: Optional[pulumi.Input[_builtins.int]] = None,
                 if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 min_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a PasswordPolicy resource.
        :param pulumi.Input[_builtins.str] database: The database this password policy belongs to.
        :param pulumi.Input[_builtins.str] schema: The schema this password policy belongs to.
        :param pulumi.Input[_builtins.str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[_builtins.int] history: (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        :param pulumi.Input[_builtins.bool] if_not_exists: (Default: `false`) Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[_builtins.int] lockout_time_mins: (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[_builtins.int] max_age_days: (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[_builtins.int] max_length: (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[_builtins.int] max_retries: (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[_builtins.int] min_age_days: (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        :param pulumi.Input[_builtins.int] min_length: (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[_builtins.int] min_lower_case_chars: (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_numeric_chars: (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_special_chars: (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_upper_case_chars: (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Whether to override a previous password policy with the same name.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if history is not None:
            pulumi.set(__self__, "history", history)
        if if_not_exists is not None:
            pulumi.set(__self__, "if_not_exists", if_not_exists)
        if lockout_time_mins is not None:
            pulumi.set(__self__, "lockout_time_mins", lockout_time_mins)
        if max_age_days is not None:
            pulumi.set(__self__, "max_age_days", max_age_days)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_age_days is not None:
            pulumi.set(__self__, "min_age_days", min_age_days)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_lower_case_chars is not None:
            pulumi.set(__self__, "min_lower_case_chars", min_lower_case_chars)
        if min_numeric_chars is not None:
            pulumi.set(__self__, "min_numeric_chars", min_numeric_chars)
        if min_special_chars is not None:
            pulumi.set(__self__, "min_special_chars", min_special_chars)
        if min_upper_case_chars is not None:
            pulumi.set(__self__, "min_upper_case_chars", min_upper_case_chars)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if or_replace is not None:
            pulumi.set(__self__, "or_replace", or_replace)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database this password policy belongs to.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema this password policy belongs to.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Adds a comment or overwrites an existing comment for the password policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def history(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        """
        return pulumi.get(self, "history")

    @history.setter
    def history(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "history", value)

    @_builtins.property
    @pulumi.getter(name="ifNotExists")
    def if_not_exists(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Prevent overwriting a previous password policy with the same name.
        """
        return pulumi.get(self, "if_not_exists")

    @if_not_exists.setter
    def if_not_exists(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "if_not_exists", value)

    @_builtins.property
    @pulumi.getter(name="lockoutTimeMins")
    def lockout_time_mins(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        """
        return pulumi.get(self, "lockout_time_mins")

    @lockout_time_mins.setter
    def lockout_time_mins(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lockout_time_mins", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeDays")
    def max_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        """
        return pulumi.get(self, "max_age_days")

    @max_age_days.setter
    def max_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_days", value)

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_length", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="minAgeDays")
    def min_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        """
        return pulumi.get(self, "min_age_days")

    @min_age_days.setter
    def min_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_age_days", value)

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_length", value)

    @_builtins.property
    @pulumi.getter(name="minLowerCaseChars")
    def min_lower_case_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_lower_case_chars")

    @min_lower_case_chars.setter
    def min_lower_case_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_lower_case_chars", value)

    @_builtins.property
    @pulumi.getter(name="minNumericChars")
    def min_numeric_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_numeric_chars")

    @min_numeric_chars.setter
    def min_numeric_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_numeric_chars", value)

    @_builtins.property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_special_chars")

    @min_special_chars.setter
    def min_special_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_special_chars", value)

    @_builtins.property
    @pulumi.getter(name="minUpperCaseChars")
    def min_upper_case_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_upper_case_chars")

    @min_upper_case_chars.setter
    def min_upper_case_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_upper_case_chars", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the password policy; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Whether to override a previous password policy with the same name.
        """
        return pulumi.get(self, "or_replace")

    @or_replace.setter
    def or_replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "or_replace", value)


@pulumi.input_type
class _PasswordPolicyState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 history: Optional[pulumi.Input[_builtins.int]] = None,
                 if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 min_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PasswordPolicy resources.
        :param pulumi.Input[_builtins.str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[_builtins.str] database: The database this password policy belongs to.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.int] history: (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        :param pulumi.Input[_builtins.bool] if_not_exists: (Default: `false`) Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[_builtins.int] lockout_time_mins: (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[_builtins.int] max_age_days: (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[_builtins.int] max_length: (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[_builtins.int] max_retries: (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[_builtins.int] min_age_days: (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        :param pulumi.Input[_builtins.int] min_length: (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[_builtins.int] min_lower_case_chars: (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_numeric_chars: (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_special_chars: (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_upper_case_chars: (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Whether to override a previous password policy with the same name.
        :param pulumi.Input[_builtins.str] schema: The schema this password policy belongs to.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if history is not None:
            pulumi.set(__self__, "history", history)
        if if_not_exists is not None:
            pulumi.set(__self__, "if_not_exists", if_not_exists)
        if lockout_time_mins is not None:
            pulumi.set(__self__, "lockout_time_mins", lockout_time_mins)
        if max_age_days is not None:
            pulumi.set(__self__, "max_age_days", max_age_days)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if min_age_days is not None:
            pulumi.set(__self__, "min_age_days", min_age_days)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_lower_case_chars is not None:
            pulumi.set(__self__, "min_lower_case_chars", min_lower_case_chars)
        if min_numeric_chars is not None:
            pulumi.set(__self__, "min_numeric_chars", min_numeric_chars)
        if min_special_chars is not None:
            pulumi.set(__self__, "min_special_chars", min_special_chars)
        if min_upper_case_chars is not None:
            pulumi.set(__self__, "min_upper_case_chars", min_upper_case_chars)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if or_replace is not None:
            pulumi.set(__self__, "or_replace", or_replace)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Adds a comment or overwrites an existing comment for the password policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database this password policy belongs to.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def history(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        """
        return pulumi.get(self, "history")

    @history.setter
    def history(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "history", value)

    @_builtins.property
    @pulumi.getter(name="ifNotExists")
    def if_not_exists(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Prevent overwriting a previous password policy with the same name.
        """
        return pulumi.get(self, "if_not_exists")

    @if_not_exists.setter
    def if_not_exists(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "if_not_exists", value)

    @_builtins.property
    @pulumi.getter(name="lockoutTimeMins")
    def lockout_time_mins(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        """
        return pulumi.get(self, "lockout_time_mins")

    @lockout_time_mins.setter
    def lockout_time_mins(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lockout_time_mins", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeDays")
    def max_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        """
        return pulumi.get(self, "max_age_days")

    @max_age_days.setter
    def max_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_days", value)

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        """
        return pulumi.get(self, "max_length")

    @max_length.setter
    def max_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_length", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="minAgeDays")
    def min_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        """
        return pulumi.get(self, "min_age_days")

    @min_age_days.setter
    def min_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_age_days", value)

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        """
        return pulumi.get(self, "min_length")

    @min_length.setter
    def min_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_length", value)

    @_builtins.property
    @pulumi.getter(name="minLowerCaseChars")
    def min_lower_case_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_lower_case_chars")

    @min_lower_case_chars.setter
    def min_lower_case_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_lower_case_chars", value)

    @_builtins.property
    @pulumi.getter(name="minNumericChars")
    def min_numeric_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_numeric_chars")

    @min_numeric_chars.setter
    def min_numeric_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_numeric_chars", value)

    @_builtins.property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_special_chars")

    @min_special_chars.setter
    def min_special_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_special_chars", value)

    @_builtins.property
    @pulumi.getter(name="minUpperCaseChars")
    def min_upper_case_chars(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_upper_case_chars")

    @min_upper_case_chars.setter
    def min_upper_case_chars(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_upper_case_chars", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the password policy; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Default: `false`) Whether to override a previous password policy with the same name.
        """
        return pulumi.get(self, "or_replace")

    @or_replace.setter
    def or_replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "or_replace", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema this password policy belongs to.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)


@pulumi.type_token("snowflake:index/passwordPolicy:PasswordPolicy")
class PasswordPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 history: Optional[pulumi.Input[_builtins.int]] = None,
                 if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 min_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        !> **Caution: Preview Feature** This feature is considered a preview feature in the provider, regardless of the state of the resource in Snowflake. We do not guarantee its stability. It will be reworked and marked as a stable feature in future releases. Breaking changes are expected, even without bumping the major version. To use this feature, add the relevant feature name to `preview_features_enabled` field in the provider configuration. Please always refer to the Getting Help section in our Github repo to best determine how to get help for your questions.

        !> **Note** According to Snowflake [docs](https://docs.snowflake.com/en/sql-reference/sql/drop-password-policy#usage-notes), a password policy cannot be dropped successfully if it is currently assigned to another object. Currently, the provider does not unassign such objects automatically. Before dropping the resource, first unassign the policy from the relevant objects. See guide for more details.

        A password policy specifies the requirements that must be met to create and reset a password to authenticate to Snowflake.

        > **Note** If a field has a default value, it is shown next to the type in the schema.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[_builtins.str] database: The database this password policy belongs to.
        :param pulumi.Input[_builtins.int] history: (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        :param pulumi.Input[_builtins.bool] if_not_exists: (Default: `false`) Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[_builtins.int] lockout_time_mins: (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[_builtins.int] max_age_days: (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[_builtins.int] max_length: (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[_builtins.int] max_retries: (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[_builtins.int] min_age_days: (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        :param pulumi.Input[_builtins.int] min_length: (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[_builtins.int] min_lower_case_chars: (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_numeric_chars: (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_special_chars: (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_upper_case_chars: (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Whether to override a previous password policy with the same name.
        :param pulumi.Input[_builtins.str] schema: The schema this password policy belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PasswordPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> **Caution: Preview Feature** This feature is considered a preview feature in the provider, regardless of the state of the resource in Snowflake. We do not guarantee its stability. It will be reworked and marked as a stable feature in future releases. Breaking changes are expected, even without bumping the major version. To use this feature, add the relevant feature name to `preview_features_enabled` field in the provider configuration. Please always refer to the Getting Help section in our Github repo to best determine how to get help for your questions.

        !> **Note** According to Snowflake [docs](https://docs.snowflake.com/en/sql-reference/sql/drop-password-policy#usage-notes), a password policy cannot be dropped successfully if it is currently assigned to another object. Currently, the provider does not unassign such objects automatically. Before dropping the resource, first unassign the policy from the relevant objects. See guide for more details.

        A password policy specifies the requirements that must be met to create and reset a password to authenticate to Snowflake.

        > **Note** If a field has a default value, it is shown next to the type in the schema.

        :param str resource_name: The name of the resource.
        :param PasswordPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PasswordPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 history: Optional[pulumi.Input[_builtins.int]] = None,
                 if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
                 lockout_time_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_length: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 min_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_lower_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PasswordPolicyArgs.__new__(PasswordPolicyArgs)

            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["history"] = history
            __props__.__dict__["if_not_exists"] = if_not_exists
            __props__.__dict__["lockout_time_mins"] = lockout_time_mins
            __props__.__dict__["max_age_days"] = max_age_days
            __props__.__dict__["max_length"] = max_length
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["min_age_days"] = min_age_days
            __props__.__dict__["min_length"] = min_length
            __props__.__dict__["min_lower_case_chars"] = min_lower_case_chars
            __props__.__dict__["min_numeric_chars"] = min_numeric_chars
            __props__.__dict__["min_special_chars"] = min_special_chars
            __props__.__dict__["min_upper_case_chars"] = min_upper_case_chars
            __props__.__dict__["name"] = name
            __props__.__dict__["or_replace"] = or_replace
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["fully_qualified_name"] = None
        super(PasswordPolicy, __self__).__init__(
            'snowflake:index/passwordPolicy:PasswordPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            history: Optional[pulumi.Input[_builtins.int]] = None,
            if_not_exists: Optional[pulumi.Input[_builtins.bool]] = None,
            lockout_time_mins: Optional[pulumi.Input[_builtins.int]] = None,
            max_age_days: Optional[pulumi.Input[_builtins.int]] = None,
            max_length: Optional[pulumi.Input[_builtins.int]] = None,
            max_retries: Optional[pulumi.Input[_builtins.int]] = None,
            min_age_days: Optional[pulumi.Input[_builtins.int]] = None,
            min_length: Optional[pulumi.Input[_builtins.int]] = None,
            min_lower_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
            min_numeric_chars: Optional[pulumi.Input[_builtins.int]] = None,
            min_special_chars: Optional[pulumi.Input[_builtins.int]] = None,
            min_upper_case_chars: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            or_replace: Optional[pulumi.Input[_builtins.bool]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None) -> 'PasswordPolicy':
        """
        Get an existing PasswordPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Adds a comment or overwrites an existing comment for the password policy.
        :param pulumi.Input[_builtins.str] database: The database this password policy belongs to.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.int] history: (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        :param pulumi.Input[_builtins.bool] if_not_exists: (Default: `false`) Prevent overwriting a previous password policy with the same name.
        :param pulumi.Input[_builtins.int] lockout_time_mins: (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        :param pulumi.Input[_builtins.int] max_age_days: (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        :param pulumi.Input[_builtins.int] max_length: (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        :param pulumi.Input[_builtins.int] max_retries: (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        :param pulumi.Input[_builtins.int] min_age_days: (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        :param pulumi.Input[_builtins.int] min_length: (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        :param pulumi.Input[_builtins.int] min_lower_case_chars: (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_numeric_chars: (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_special_chars: (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.int] min_upper_case_chars: (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        :param pulumi.Input[_builtins.str] name: Identifier for the password policy; must be unique for your account.
        :param pulumi.Input[_builtins.bool] or_replace: (Default: `false`) Whether to override a previous password policy with the same name.
        :param pulumi.Input[_builtins.str] schema: The schema this password policy belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PasswordPolicyState.__new__(_PasswordPolicyState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["database"] = database
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["history"] = history
        __props__.__dict__["if_not_exists"] = if_not_exists
        __props__.__dict__["lockout_time_mins"] = lockout_time_mins
        __props__.__dict__["max_age_days"] = max_age_days
        __props__.__dict__["max_length"] = max_length
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["min_age_days"] = min_age_days
        __props__.__dict__["min_length"] = min_length
        __props__.__dict__["min_lower_case_chars"] = min_lower_case_chars
        __props__.__dict__["min_numeric_chars"] = min_numeric_chars
        __props__.__dict__["min_special_chars"] = min_special_chars
        __props__.__dict__["min_upper_case_chars"] = min_upper_case_chars
        __props__.__dict__["name"] = name
        __props__.__dict__["or_replace"] = or_replace
        __props__.__dict__["schema"] = schema
        return PasswordPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Adds a comment or overwrites an existing comment for the password policy.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database this password policy belongs to.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def history(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `0`) Specifies the number of the most recent passwords that Snowflake stores. These stored passwords cannot be repeated when a user updates their password value. The current password value does not count towards the history. When you increase the history value, Snowflake saves the previous values. When you decrease the value, Snowflake saves the stored values up to that value that is set. For example, if the history value is 8 and you change the history value to 3, Snowflake stores the most recent 3 passwords and deletes the 5 older password values from the history. Default: 0 Max: 24
        """
        return pulumi.get(self, "history")

    @_builtins.property
    @pulumi.getter(name="ifNotExists")
    def if_not_exists(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `false`) Prevent overwriting a previous password policy with the same name.
        """
        return pulumi.get(self, "if_not_exists")

    @_builtins.property
    @pulumi.getter(name="lockoutTimeMins")
    def lockout_time_mins(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `15`) Specifies the number of minutes the user account will be locked after exhausting the designated number of password retries (i.e. PASSWORD*MAX*RETRIES). Supported range: 1 to 999, inclusive. Default: 15
        """
        return pulumi.get(self, "lockout_time_mins")

    @_builtins.property
    @pulumi.getter(name="maxAgeDays")
    def max_age_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `90`) Specifies the maximum number of days before the password must be changed. Supported range: 0 to 999, inclusive. A value of zero (i.e. 0) indicates that the password does not need to be changed. Snowflake does not recommend choosing this value for a default account-level password policy or for any user-level policy. Instead, choose a value that meets your internal security guidelines. Default: 90, which means the password must be changed every 90 days.
        """
        return pulumi.get(self, "max_age_days")

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `256`) Specifies the maximum number of characters the password must contain. This number must be greater than or equal to the sum of PASSWORD*MIN*LENGTH, PASSWORD*MIN*UPPER*CASE*CHARS, and PASSWORD*MIN*LOWER*CASE*CHARS. Supported range: 8 to 256, inclusive. Default: 256
        """
        return pulumi.get(self, "max_length")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `5`) Specifies the maximum number of attempts to enter a password before being locked out. Supported range: 1 to 10, inclusive. Default: 5
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="minAgeDays")
    def min_age_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `0`) Specifies the number of days the user must wait before a recently changed password can be changed again. Supported range: 0 to 999, inclusive. Default: 0
        """
        return pulumi.get(self, "min_age_days")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `8`) Specifies the minimum number of characters the password must contain. Supported range: 8 to 256, inclusive. Default: 8
        """
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="minLowerCaseChars")
    def min_lower_case_chars(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of lowercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_lower_case_chars")

    @_builtins.property
    @pulumi.getter(name="minNumericChars")
    def min_numeric_chars(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of numeric characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_numeric_chars")

    @_builtins.property
    @pulumi.getter(name="minSpecialChars")
    def min_special_chars(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of special characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_special_chars")

    @_builtins.property
    @pulumi.getter(name="minUpperCaseChars")
    def min_upper_case_chars(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: `1`) Specifies the minimum number of uppercase characters the password must contain. Supported range: 0 to 256, inclusive. Default: 1
        """
        return pulumi.get(self, "min_upper_case_chars")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the password policy; must be unique for your account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orReplace")
    def or_replace(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Default: `false`) Whether to override a previous password policy with the same name.
        """
        return pulumi.get(self, "or_replace")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema this password policy belongs to.
        """
        return pulumi.get(self, "schema")

