# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceMonitorArgs', 'ResourceMonitor']

@pulumi.input_type
class ResourceMonitorArgs:
    def __init__(__self__, *,
                 credit_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 end_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 notify_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_immediate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 suspend_trigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ResourceMonitor resource.
        :param pulumi.Input[_builtins.int] credit_quota: The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        :param pulumi.Input[_builtins.str] end_timestamp: The date and time when the resource monitor suspends the assigned warehouses.
        :param pulumi.Input[_builtins.str] frequency: The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.str] name: Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] notify_triggers: Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_users: Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] start_timestamp: The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.int] suspend_immediate_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        :param pulumi.Input[_builtins.int] suspend_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        if credit_quota is not None:
            pulumi.set(__self__, "credit_quota", credit_quota)
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notify_triggers is not None:
            pulumi.set(__self__, "notify_triggers", notify_triggers)
        if notify_users is not None:
            pulumi.set(__self__, "notify_users", notify_users)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if suspend_immediate_trigger is not None:
            pulumi.set(__self__, "suspend_immediate_trigger", suspend_immediate_trigger)
        if suspend_trigger is not None:
            pulumi.set(__self__, "suspend_trigger", suspend_trigger)

    @_builtins.property
    @pulumi.getter(name="creditQuota")
    def credit_quota(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        """
        return pulumi.get(self, "credit_quota")

    @credit_quota.setter
    def credit_quota(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credit_quota", value)

    @_builtins.property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the resource monitor suspends the assigned warehouses.
        """
        return pulumi.get(self, "end_timestamp")

    @end_timestamp.setter
    def end_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notifyTriggers")
    def notify_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        """
        return pulumi.get(self, "notify_triggers")

    @notify_triggers.setter
    def notify_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "notify_triggers", value)

    @_builtins.property
    @pulumi.getter(name="notifyUsers")
    def notify_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        """
        return pulumi.get(self, "notify_users")

    @notify_users.setter
    def notify_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notify_users", value)

    @_builtins.property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="suspendImmediateTrigger")
    def suspend_immediate_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        return pulumi.get(self, "suspend_immediate_trigger")

    @suspend_immediate_trigger.setter
    def suspend_immediate_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_immediate_trigger", value)

    @_builtins.property
    @pulumi.getter(name="suspendTrigger")
    def suspend_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        return pulumi.get(self, "suspend_trigger")

    @suspend_trigger.setter
    def suspend_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_trigger", value)


@pulumi.input_type
class _ResourceMonitorState:
    def __init__(__self__, *,
                 credit_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 end_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 notify_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceMonitorShowOutputArgs']]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_immediate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 suspend_trigger: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ResourceMonitor resources.
        :param pulumi.Input[_builtins.int] credit_quota: The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        :param pulumi.Input[_builtins.str] end_timestamp: The date and time when the resource monitor suspends the assigned warehouses.
        :param pulumi.Input[_builtins.str] frequency: The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] notify_triggers: Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_users: Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceMonitorShowOutputArgs']]] show_outputs: Outputs the result of `SHOW RESOURCE MONITORS` for the given resource monitor.
        :param pulumi.Input[_builtins.str] start_timestamp: The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.int] suspend_immediate_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        :param pulumi.Input[_builtins.int] suspend_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        if credit_quota is not None:
            pulumi.set(__self__, "credit_quota", credit_quota)
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notify_triggers is not None:
            pulumi.set(__self__, "notify_triggers", notify_triggers)
        if notify_users is not None:
            pulumi.set(__self__, "notify_users", notify_users)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if suspend_immediate_trigger is not None:
            pulumi.set(__self__, "suspend_immediate_trigger", suspend_immediate_trigger)
        if suspend_trigger is not None:
            pulumi.set(__self__, "suspend_trigger", suspend_trigger)

    @_builtins.property
    @pulumi.getter(name="creditQuota")
    def credit_quota(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        """
        return pulumi.get(self, "credit_quota")

    @credit_quota.setter
    def credit_quota(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credit_quota", value)

    @_builtins.property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the resource monitor suspends the assigned warehouses.
        """
        return pulumi.get(self, "end_timestamp")

    @end_timestamp.setter
    def end_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notifyTriggers")
    def notify_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        """
        return pulumi.get(self, "notify_triggers")

    @notify_triggers.setter
    def notify_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "notify_triggers", value)

    @_builtins.property
    @pulumi.getter(name="notifyUsers")
    def notify_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        """
        return pulumi.get(self, "notify_users")

    @notify_users.setter
    def notify_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notify_users", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceMonitorShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW RESOURCE MONITORS` for the given resource monitor.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceMonitorShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="suspendImmediateTrigger")
    def suspend_immediate_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        return pulumi.get(self, "suspend_immediate_trigger")

    @suspend_immediate_trigger.setter
    def suspend_immediate_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_immediate_trigger", value)

    @_builtins.property
    @pulumi.getter(name="suspendTrigger")
    def suspend_trigger(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        return pulumi.get(self, "suspend_trigger")

    @suspend_trigger.setter
    def suspend_trigger(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "suspend_trigger", value)


@pulumi.type_token("snowflake:index/resourceMonitor:ResourceMonitor")
class ResourceMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credit_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 end_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 notify_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_immediate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 suspend_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/resourceMonitor:ResourceMonitor example '"<resource_monitor_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] credit_quota: The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        :param pulumi.Input[_builtins.str] end_timestamp: The date and time when the resource monitor suspends the assigned warehouses.
        :param pulumi.Input[_builtins.str] frequency: The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.str] name: Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] notify_triggers: Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_users: Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] start_timestamp: The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.int] suspend_immediate_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        :param pulumi.Input[_builtins.int] suspend_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourceMonitorArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/resourceMonitor:ResourceMonitor example '"<resource_monitor_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ResourceMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credit_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 end_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 notify_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 start_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 suspend_immediate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 suspend_trigger: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceMonitorArgs.__new__(ResourceMonitorArgs)

            __props__.__dict__["credit_quota"] = credit_quota
            __props__.__dict__["end_timestamp"] = end_timestamp
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["name"] = name
            __props__.__dict__["notify_triggers"] = notify_triggers
            __props__.__dict__["notify_users"] = notify_users
            __props__.__dict__["start_timestamp"] = start_timestamp
            __props__.__dict__["suspend_immediate_trigger"] = suspend_immediate_trigger
            __props__.__dict__["suspend_trigger"] = suspend_trigger
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(ResourceMonitor, __self__).__init__(
            'snowflake:index/resourceMonitor:ResourceMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credit_quota: Optional[pulumi.Input[_builtins.int]] = None,
            end_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            frequency: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notify_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            notify_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceMonitorShowOutputArgs', 'ResourceMonitorShowOutputArgsDict']]]]] = None,
            start_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            suspend_immediate_trigger: Optional[pulumi.Input[_builtins.int]] = None,
            suspend_trigger: Optional[pulumi.Input[_builtins.int]] = None) -> 'ResourceMonitor':
        """
        Get an existing ResourceMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] credit_quota: The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        :param pulumi.Input[_builtins.str] end_timestamp: The date and time when the resource monitor suspends the assigned warehouses.
        :param pulumi.Input[_builtins.str] frequency: The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] notify_triggers: Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_users: Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceMonitorShowOutputArgs', 'ResourceMonitorShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW RESOURCE MONITORS` for the given resource monitor.
        :param pulumi.Input[_builtins.str] start_timestamp: The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        :param pulumi.Input[_builtins.int] suspend_immediate_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        :param pulumi.Input[_builtins.int] suspend_trigger: Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceMonitorState.__new__(_ResourceMonitorState)

        __props__.__dict__["credit_quota"] = credit_quota
        __props__.__dict__["end_timestamp"] = end_timestamp
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["notify_triggers"] = notify_triggers
        __props__.__dict__["notify_users"] = notify_users
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["start_timestamp"] = start_timestamp
        __props__.__dict__["suspend_immediate_trigger"] = suspend_immediate_trigger
        __props__.__dict__["suspend_trigger"] = suspend_trigger
        return ResourceMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creditQuota")
    def credit_quota(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
        """
        return pulumi.get(self, "credit_quota")

    @_builtins.property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The date and time when the resource monitor suspends the assigned warehouses.
        """
        return pulumi.get(self, "end_timestamp")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notifyTriggers")
    def notify_triggers(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
        """
        return pulumi.get(self, "notify_triggers")

    @_builtins.property
    @pulumi.getter(name="notifyUsers")
    def notify_users(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see docs.
        """
        return pulumi.get(self, "notify_users")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ResourceMonitorShowOutput']]:
        """
        Outputs the result of `SHOW RESOURCE MONITORS` for the given resource monitor.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
        """
        return pulumi.get(self, "start_timestamp")

    @_builtins.property
    @pulumi.getter(name="suspendImmediateTrigger")
    def suspend_immediate_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        return pulumi.get(self, "suspend_immediate_trigger")

    @_builtins.property
    @pulumi.getter(name="suspendTrigger")
    def suspend_trigger(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
        """
        return pulumi.get(self, "suspend_trigger")

