# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 compute_pool: pulumi.Input[_builtins.str],
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input['ServiceFromSpecificationArgs']] = None,
                 from_specification_template: Optional[pulumi.Input['ServiceFromSpecificationTemplateArgs']] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input['ServiceFromSpecificationArgs'] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input['ServiceFromSpecificationTemplateArgs'] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.int] max_instances: Specifies the maximum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_instances: Specifies the minimum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_ready_instances: Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        pulumi.set(__self__, "compute_pool", compute_pool)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend_secs is not None:
            pulumi.set(__self__, "auto_suspend_secs", auto_suspend_secs)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if external_access_integrations is not None:
            pulumi.set(__self__, "external_access_integrations", external_access_integrations)
        if from_specification is not None:
            pulumi.set(__self__, "from_specification", from_specification)
        if from_specification_template is not None:
            pulumi.set(__self__, "from_specification_template", from_specification_template)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if min_ready_instances is not None:
            pulumi.set(__self__, "min_ready_instances", min_ready_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_warehouse is not None:
            pulumi.set(__self__, "query_warehouse", query_warehouse)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resume", value)

    @_builtins.property
    @pulumi.getter(name="autoSuspendSecs")
    def auto_suspend_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        """
        return pulumi.get(self, "auto_suspend_secs")

    @auto_suspend_secs.setter
    def auto_suspend_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_suspend_secs", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the service.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of the external access integrations that allow your service to access external sites.
        """
        return pulumi.get(self, "external_access_integrations")

    @external_access_integrations.setter
    def external_access_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_access_integrations", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecification")
    def from_specification(self) -> Optional[pulumi.Input['ServiceFromSpecificationArgs']]:
        """
        Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification")

    @from_specification.setter
    def from_specification(self, value: Optional[pulumi.Input['ServiceFromSpecificationArgs']]):
        pulumi.set(self, "from_specification", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecificationTemplate")
    def from_specification_template(self) -> Optional[pulumi.Input['ServiceFromSpecificationTemplateArgs']]:
        """
        Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification_template")

    @from_specification_template.setter
    def from_specification_template(self, value: Optional[pulumi.Input['ServiceFromSpecificationTemplateArgs']]):
        pulumi.set(self, "from_specification_template", value)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of service instances to run.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instances", value)

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of service instances to run.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instances", value)

    @_builtins.property
    @pulumi.getter(name="minReadyInstances")
    def min_ready_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        """
        return pulumi.get(self, "min_ready_instances")

    @min_ready_instances.setter
    def min_ready_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ready_instances", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryWarehouse")
    def query_warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "query_warehouse")

    @query_warehouse.setter
    def query_warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_warehouse", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDescribeOutputArgs']]]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input['ServiceFromSpecificationArgs']] = None,
                 from_specification_template: Optional[pulumi.Input['ServiceFromSpecificationTemplateArgs']] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE SERVICE` for the given service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input['ServiceFromSpecificationArgs'] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input['ServiceFromSpecificationTemplateArgs'] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.int] max_instances: Specifies the maximum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_instances: Specifies the minimum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_ready_instances: Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] service_type: Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceShowOutputArgs']]] show_outputs: Outputs the result of `SHOW SERVICES` for the given service.
        """
        if auto_resume is not None:
            pulumi.set(__self__, "auto_resume", auto_resume)
        if auto_suspend_secs is not None:
            pulumi.set(__self__, "auto_suspend_secs", auto_suspend_secs)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compute_pool is not None:
            pulumi.set(__self__, "compute_pool", compute_pool)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if external_access_integrations is not None:
            pulumi.set(__self__, "external_access_integrations", external_access_integrations)
        if from_specification is not None:
            pulumi.set(__self__, "from_specification", from_specification)
        if from_specification_template is not None:
            pulumi.set(__self__, "from_specification_template", from_specification_template)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if min_ready_instances is not None:
            pulumi.set(__self__, "min_ready_instances", min_ready_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_warehouse is not None:
            pulumi.set(__self__, "query_warehouse", query_warehouse)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @auto_resume.setter
    def auto_resume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_resume", value)

    @_builtins.property
    @pulumi.getter(name="autoSuspendSecs")
    def auto_suspend_secs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        """
        return pulumi.get(self, "auto_suspend_secs")

    @auto_suspend_secs.setter
    def auto_suspend_secs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_suspend_secs", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the service.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "compute_pool")

    @compute_pool.setter
    def compute_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_pool", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE SERVICE` for the given service.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of the external access integrations that allow your service to access external sites.
        """
        return pulumi.get(self, "external_access_integrations")

    @external_access_integrations.setter
    def external_access_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_access_integrations", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecification")
    def from_specification(self) -> Optional[pulumi.Input['ServiceFromSpecificationArgs']]:
        """
        Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification")

    @from_specification.setter
    def from_specification(self, value: Optional[pulumi.Input['ServiceFromSpecificationArgs']]):
        pulumi.set(self, "from_specification", value)

    @_builtins.property
    @pulumi.getter(name="fromSpecificationTemplate")
    def from_specification_template(self) -> Optional[pulumi.Input['ServiceFromSpecificationTemplateArgs']]:
        """
        Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification_template")

    @from_specification_template.setter
    def from_specification_template(self, value: Optional[pulumi.Input['ServiceFromSpecificationTemplateArgs']]):
        pulumi.set(self, "from_specification_template", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of service instances to run.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instances", value)

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of service instances to run.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instances", value)

    @_builtins.property
    @pulumi.getter(name="minReadyInstances")
    def min_ready_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        """
        return pulumi.get(self, "min_ready_instances")

    @min_ready_instances.setter
    def min_ready_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ready_instances", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryWarehouse")
    def query_warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "query_warehouse")

    @query_warehouse.setter
    def query_warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_warehouse", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW SERVICES` for the given service.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input[Union['ServiceFromSpecificationArgs', 'ServiceFromSpecificationArgsDict']]] = None,
                 from_specification_template: Optional[pulumi.Input[Union['ServiceFromSpecificationTemplateArgs', 'ServiceFromSpecificationTemplateArgsDict']]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/service:Service example '"<database_name>"."<schema_name>"."<service_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input[Union['ServiceFromSpecificationArgs', 'ServiceFromSpecificationArgsDict']] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[Union['ServiceFromSpecificationTemplateArgs', 'ServiceFromSpecificationTemplateArgsDict']] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.int] max_instances: Specifies the maximum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_instances: Specifies the minimum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_ready_instances: Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/service:Service example '"<database_name>"."<schema_name>"."<service_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 from_specification: Optional[pulumi.Input[Union['ServiceFromSpecificationArgs', 'ServiceFromSpecificationArgsDict']]] = None,
                 from_specification_template: Optional[pulumi.Input[Union['ServiceFromSpecificationTemplateArgs', 'ServiceFromSpecificationTemplateArgsDict']]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["auto_resume"] = auto_resume
            __props__.__dict__["auto_suspend_secs"] = auto_suspend_secs
            __props__.__dict__["comment"] = comment
            if compute_pool is None and not opts.urn:
                raise TypeError("Missing required property 'compute_pool'")
            __props__.__dict__["compute_pool"] = compute_pool
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["external_access_integrations"] = external_access_integrations
            __props__.__dict__["from_specification"] = from_specification
            __props__.__dict__["from_specification_template"] = from_specification_template
            __props__.__dict__["max_instances"] = max_instances
            __props__.__dict__["min_instances"] = min_instances
            __props__.__dict__["min_ready_instances"] = min_ready_instances
            __props__.__dict__["name"] = name
            __props__.__dict__["query_warehouse"] = query_warehouse
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["show_outputs"] = None
        super(Service, __self__).__init__(
            'snowflake:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_resume: Optional[pulumi.Input[_builtins.str]] = None,
            auto_suspend_secs: Optional[pulumi.Input[_builtins.int]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            compute_pool: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDescribeOutputArgs', 'ServiceDescribeOutputArgsDict']]]]] = None,
            external_access_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            from_specification: Optional[pulumi.Input[Union['ServiceFromSpecificationArgs', 'ServiceFromSpecificationArgsDict']]] = None,
            from_specification_template: Optional[pulumi.Input[Union['ServiceFromSpecificationTemplateArgs', 'ServiceFromSpecificationTemplateArgsDict']]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_instances: Optional[pulumi.Input[_builtins.int]] = None,
            min_instances: Optional[pulumi.Input[_builtins.int]] = None,
            min_ready_instances: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query_warehouse: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceShowOutputArgs', 'ServiceShowOutputArgsDict']]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_resume: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] auto_suspend_secs: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the service.
        :param pulumi.Input[_builtins.str] compute_pool: Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] database: The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDescribeOutputArgs', 'ServiceDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE SERVICE` for the given service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_access_integrations: Specifies the names of the external access integrations that allow your service to access external sites.
        :param pulumi.Input[Union['ServiceFromSpecificationArgs', 'ServiceFromSpecificationArgsDict']] from_specification: Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[Union['ServiceFromSpecificationTemplateArgs', 'ServiceFromSpecificationTemplateArgsDict']] from_specification_template: Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.int] max_instances: Specifies the maximum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_instances: Specifies the minimum number of service instances to run.
        :param pulumi.Input[_builtins.int] min_ready_instances: Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] query_warehouse: Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] service_type: Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceShowOutputArgs', 'ServiceShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW SERVICES` for the given service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["auto_resume"] = auto_resume
        __props__.__dict__["auto_suspend_secs"] = auto_suspend_secs
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compute_pool"] = compute_pool
        __props__.__dict__["database"] = database
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["external_access_integrations"] = external_access_integrations
        __props__.__dict__["from_specification"] = from_specification
        __props__.__dict__["from_specification_template"] = from_specification_template
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["max_instances"] = max_instances
        __props__.__dict__["min_instances"] = min_instances
        __props__.__dict__["min_ready_instances"] = min_ready_instances
        __props__.__dict__["name"] = name
        __props__.__dict__["query_warehouse"] = query_warehouse
        __props__.__dict__["schema"] = schema
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["show_outputs"] = show_outputs
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoResume")
    def auto_resume(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "auto_resume")

    @_builtins.property
    @pulumi.getter(name="autoSuspendSecs")
    def auto_suspend_secs(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
        """
        return pulumi.get(self, "auto_suspend_secs")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the service.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="computePool")
    def compute_pool(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "compute_pool")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.ServiceDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE SERVICE` for the given service.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="externalAccessIntegrations")
    def external_access_integrations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the names of the external access integrations that allow your service to access external sites.
        """
        return pulumi.get(self, "external_access_integrations")

    @_builtins.property
    @pulumi.getter(name="fromSpecification")
    def from_specification(self) -> pulumi.Output[Optional['outputs.ServiceFromSpecification']]:
        """
        Specifies the service specification to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification")

    @_builtins.property
    @pulumi.getter(name="fromSpecificationTemplate")
    def from_specification_template(self) -> pulumi.Output[Optional['outputs.ServiceFromSpecificationTemplate']]:
        """
        Specifies the service specification template to use for the service. Note that external changes on this field and nested fields are not detected. Use correctly formatted YAML files. Watch out for the space/tabs indentation. See [service specification](https://docs.snowflake.com/en/developer-guide/snowpark-container-services/specification-reference#general-guidelines) for more information.
        """
        return pulumi.get(self, "from_specification_template")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of service instances to run.
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the minimum number of service instances to run.
        """
        return pulumi.get(self, "min_instances")

    @_builtins.property
    @pulumi.getter(name="minReadyInstances")
    def min_ready_instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
        """
        return pulumi.get(self, "min_ready_instances")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryWarehouse")
    def query_warehouse(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "query_warehouse")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the service. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a type for the service. This field is used for checking external changes and recreating the resources if needed.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ServiceShowOutput']]:
        """
        Outputs the result of `SHOW SERVICES` for the given service.
        """
        return pulumi.get(self, "show_outputs")

