# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudCredentialArgs', 'CloudCredential']

@pulumi.input_type
class CloudCredentialArgs:
    def __init__(__self__, *,
                 amazonec2_credential_config: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 azure_credential_config: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']] = None,
                 google_credential_config: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 linode_credential_config: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openstack_credential_config: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']] = None,
                 vsphere_credential_config: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']] = None):
        """
        The set of arguments for constructing a CloudCredential resource.
        :param pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs'] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialAzureCredentialConfigArgs'] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] description: Description for the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs'] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialGoogleCredentialConfigArgs'] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialLinodeCredentialConfigArgs'] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] name: The name of the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs'] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialVsphereCredentialConfigArgs'] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        if amazonec2_credential_config is not None:
            pulumi.set(__self__, "amazonec2_credential_config", amazonec2_credential_config)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_credential_config is not None:
            pulumi.set(__self__, "azure_credential_config", azure_credential_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if digitalocean_credential_config is not None:
            pulumi.set(__self__, "digitalocean_credential_config", digitalocean_credential_config)
        if google_credential_config is not None:
            pulumi.set(__self__, "google_credential_config", google_credential_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linode_credential_config is not None:
            pulumi.set(__self__, "linode_credential_config", linode_credential_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openstack_credential_config is not None:
            pulumi.set(__self__, "openstack_credential_config", openstack_credential_config)
        if vsphere_credential_config is not None:
            pulumi.set(__self__, "vsphere_credential_config", vsphere_credential_config)

    @property
    @pulumi.getter(name="amazonec2CredentialConfig")
    def amazonec2_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]:
        """
        AWS config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "amazonec2_credential_config")

    @amazonec2_credential_config.setter
    def amazonec2_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]):
        pulumi.set(self, "amazonec2_credential_config", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Annotations for Cloud Credential object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="azureCredentialConfig")
    def azure_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]:
        """
        Azure config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "azure_credential_config")

    @azure_credential_config.setter
    def azure_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]):
        pulumi.set(self, "azure_credential_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the Cloud Credential (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="digitaloceanCredentialConfig")
    def digitalocean_credential_config(self) -> Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]:
        """
        DigitalOcean config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "digitalocean_credential_config")

    @digitalocean_credential_config.setter
    def digitalocean_credential_config(self, value: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]):
        pulumi.set(self, "digitalocean_credential_config", value)

    @property
    @pulumi.getter(name="googleCredentialConfig")
    def google_credential_config(self) -> Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]:
        """
        Google config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "google_credential_config")

    @google_credential_config.setter
    def google_credential_config(self, value: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]):
        pulumi.set(self, "google_credential_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Labels for Cloud Credential object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linodeCredentialConfig")
    def linode_credential_config(self) -> Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]:
        """
        Linode config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "linode_credential_config")

    @linode_credential_config.setter
    def linode_credential_config(self, value: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]):
        pulumi.set(self, "linode_credential_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Credential (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openstackCredentialConfig")
    def openstack_credential_config(self) -> Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]:
        """
        OpenStack config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "openstack_credential_config")

    @openstack_credential_config.setter
    def openstack_credential_config(self, value: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]):
        pulumi.set(self, "openstack_credential_config", value)

    @property
    @pulumi.getter(name="vsphereCredentialConfig")
    def vsphere_credential_config(self) -> Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]:
        """
        vSphere config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_credential_config")

    @vsphere_credential_config.setter
    def vsphere_credential_config(self, value: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]):
        pulumi.set(self, "vsphere_credential_config", value)


@pulumi.input_type
class _CloudCredentialState:
    def __init__(__self__, *,
                 amazonec2_credential_config: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 azure_credential_config: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']] = None,
                 driver: Optional[pulumi.Input[str]] = None,
                 google_credential_config: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 linode_credential_config: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openstack_credential_config: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']] = None,
                 vsphere_credential_config: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']] = None):
        """
        Input properties used for looking up and filtering CloudCredential resources.
        :param pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs'] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialAzureCredentialConfigArgs'] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] description: Description for the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs'] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] driver: (Computed) The driver of the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialGoogleCredentialConfigArgs'] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input['CloudCredentialLinodeCredentialConfigArgs'] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] name: The name of the Cloud Credential (string)
        :param pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs'] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input['CloudCredentialVsphereCredentialConfigArgs'] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        if amazonec2_credential_config is not None:
            pulumi.set(__self__, "amazonec2_credential_config", amazonec2_credential_config)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_credential_config is not None:
            pulumi.set(__self__, "azure_credential_config", azure_credential_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if digitalocean_credential_config is not None:
            pulumi.set(__self__, "digitalocean_credential_config", digitalocean_credential_config)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if google_credential_config is not None:
            pulumi.set(__self__, "google_credential_config", google_credential_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linode_credential_config is not None:
            pulumi.set(__self__, "linode_credential_config", linode_credential_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openstack_credential_config is not None:
            pulumi.set(__self__, "openstack_credential_config", openstack_credential_config)
        if vsphere_credential_config is not None:
            pulumi.set(__self__, "vsphere_credential_config", vsphere_credential_config)

    @property
    @pulumi.getter(name="amazonec2CredentialConfig")
    def amazonec2_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]:
        """
        AWS config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "amazonec2_credential_config")

    @amazonec2_credential_config.setter
    def amazonec2_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAmazonec2CredentialConfigArgs']]):
        pulumi.set(self, "amazonec2_credential_config", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Annotations for Cloud Credential object (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="azureCredentialConfig")
    def azure_credential_config(self) -> Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]:
        """
        Azure config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "azure_credential_config")

    @azure_credential_config.setter
    def azure_credential_config(self, value: Optional[pulumi.Input['CloudCredentialAzureCredentialConfigArgs']]):
        pulumi.set(self, "azure_credential_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the Cloud Credential (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="digitaloceanCredentialConfig")
    def digitalocean_credential_config(self) -> Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]:
        """
        DigitalOcean config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "digitalocean_credential_config")

    @digitalocean_credential_config.setter
    def digitalocean_credential_config(self, value: Optional[pulumi.Input['CloudCredentialDigitaloceanCredentialConfigArgs']]):
        pulumi.set(self, "digitalocean_credential_config", value)

    @property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) The driver of the Cloud Credential (string)
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="googleCredentialConfig")
    def google_credential_config(self) -> Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]:
        """
        Google config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "google_credential_config")

    @google_credential_config.setter
    def google_credential_config(self, value: Optional[pulumi.Input['CloudCredentialGoogleCredentialConfigArgs']]):
        pulumi.set(self, "google_credential_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Labels for Cloud Credential object (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linodeCredentialConfig")
    def linode_credential_config(self) -> Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]:
        """
        Linode config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "linode_credential_config")

    @linode_credential_config.setter
    def linode_credential_config(self, value: Optional[pulumi.Input['CloudCredentialLinodeCredentialConfigArgs']]):
        pulumi.set(self, "linode_credential_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Credential (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openstackCredentialConfig")
    def openstack_credential_config(self) -> Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]:
        """
        OpenStack config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "openstack_credential_config")

    @openstack_credential_config.setter
    def openstack_credential_config(self, value: Optional[pulumi.Input['CloudCredentialOpenstackCredentialConfigArgs']]):
        pulumi.set(self, "openstack_credential_config", value)

    @property
    @pulumi.getter(name="vsphereCredentialConfig")
    def vsphere_credential_config(self) -> Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]:
        """
        vSphere config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_credential_config")

    @vsphere_credential_config.setter
    def vsphere_credential_config(self, value: Optional[pulumi.Input['CloudCredentialVsphereCredentialConfigArgs']]):
        pulumi.set(self, "vsphere_credential_config", value)


class CloudCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazonec2_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialAmazonec2CredentialConfigArgs']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 azure_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialAzureCredentialConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialDigitaloceanCredentialConfigArgs']]] = None,
                 google_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialGoogleCredentialConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 linode_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialLinodeCredentialConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openstack_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialOpenstackCredentialConfigArgs']]] = None,
                 vsphere_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialVsphereCredentialConfigArgs']]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Cloud Credential resource. This can be used to create Cloud Credential for Rancher v2.2.x and retrieve their information.

        amazonec2, azure, digitalocean, linode, openstack and vsphere credentials config are supported for Cloud Credential.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cloud Credential
        foo = rancher2.CloudCredential("foo",
            amazonec2_credential_config=rancher2.CloudCredentialAmazonec2CredentialConfigArgs(
                access_key="<AWS_ACCESS_KEY>",
                secret_key="<AWS_SECRET_KEY>",
            ),
            description="foo test")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CloudCredentialAmazonec2CredentialConfigArgs']] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input[pulumi.InputType['CloudCredentialAzureCredentialConfigArgs']] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] description: Description for the Cloud Credential (string)
        :param pulumi.Input[pulumi.InputType['CloudCredentialDigitaloceanCredentialConfigArgs']] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['CloudCredentialGoogleCredentialConfigArgs']] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input[pulumi.InputType['CloudCredentialLinodeCredentialConfigArgs']] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] name: The name of the Cloud Credential (string)
        :param pulumi.Input[pulumi.InputType['CloudCredentialOpenstackCredentialConfigArgs']] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['CloudCredentialVsphereCredentialConfigArgs']] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CloudCredentialArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Cloud Credential resource. This can be used to create Cloud Credential for Rancher v2.2.x and retrieve their information.

        amazonec2, azure, digitalocean, linode, openstack and vsphere credentials config are supported for Cloud Credential.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cloud Credential
        foo = rancher2.CloudCredential("foo",
            amazonec2_credential_config=rancher2.CloudCredentialAmazonec2CredentialConfigArgs(
                access_key="<AWS_ACCESS_KEY>",
                secret_key="<AWS_SECRET_KEY>",
            ),
            description="foo test")
        ```

        :param str resource_name: The name of the resource.
        :param CloudCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazonec2_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialAmazonec2CredentialConfigArgs']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 azure_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialAzureCredentialConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 digitalocean_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialDigitaloceanCredentialConfigArgs']]] = None,
                 google_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialGoogleCredentialConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 linode_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialLinodeCredentialConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 openstack_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialOpenstackCredentialConfigArgs']]] = None,
                 vsphere_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialVsphereCredentialConfigArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudCredentialArgs.__new__(CloudCredentialArgs)

            __props__.__dict__["amazonec2_credential_config"] = amazonec2_credential_config
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["azure_credential_config"] = azure_credential_config
            __props__.__dict__["description"] = description
            __props__.__dict__["digitalocean_credential_config"] = digitalocean_credential_config
            __props__.__dict__["google_credential_config"] = google_credential_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linode_credential_config"] = linode_credential_config
            __props__.__dict__["name"] = name
            __props__.__dict__["openstack_credential_config"] = openstack_credential_config
            __props__.__dict__["vsphere_credential_config"] = vsphere_credential_config
            __props__.__dict__["driver"] = None
        super(CloudCredential, __self__).__init__(
            'rancher2:index/cloudCredential:CloudCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amazonec2_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialAmazonec2CredentialConfigArgs']]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            azure_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialAzureCredentialConfigArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            digitalocean_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialDigitaloceanCredentialConfigArgs']]] = None,
            driver: Optional[pulumi.Input[str]] = None,
            google_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialGoogleCredentialConfigArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            linode_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialLinodeCredentialConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            openstack_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialOpenstackCredentialConfigArgs']]] = None,
            vsphere_credential_config: Optional[pulumi.Input[pulumi.InputType['CloudCredentialVsphereCredentialConfigArgs']]] = None) -> 'CloudCredential':
        """
        Get an existing CloudCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CloudCredentialAmazonec2CredentialConfigArgs']] amazonec2_credential_config: AWS config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for Cloud Credential object (map)
        :param pulumi.Input[pulumi.InputType['CloudCredentialAzureCredentialConfigArgs']] azure_credential_config: Azure config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] description: Description for the Cloud Credential (string)
        :param pulumi.Input[pulumi.InputType['CloudCredentialDigitaloceanCredentialConfigArgs']] digitalocean_credential_config: DigitalOcean config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] driver: (Computed) The driver of the Cloud Credential (string)
        :param pulumi.Input[pulumi.InputType['CloudCredentialGoogleCredentialConfigArgs']] google_credential_config: Google config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for Cloud Credential object (map)
        :param pulumi.Input[pulumi.InputType['CloudCredentialLinodeCredentialConfigArgs']] linode_credential_config: Linode config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[str] name: The name of the Cloud Credential (string)
        :param pulumi.Input[pulumi.InputType['CloudCredentialOpenstackCredentialConfigArgs']] openstack_credential_config: OpenStack config for the Cloud Credential (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['CloudCredentialVsphereCredentialConfigArgs']] vsphere_credential_config: vSphere config for the Cloud Credential (list maxitems:1)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudCredentialState.__new__(_CloudCredentialState)

        __props__.__dict__["amazonec2_credential_config"] = amazonec2_credential_config
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["azure_credential_config"] = azure_credential_config
        __props__.__dict__["description"] = description
        __props__.__dict__["digitalocean_credential_config"] = digitalocean_credential_config
        __props__.__dict__["driver"] = driver
        __props__.__dict__["google_credential_config"] = google_credential_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linode_credential_config"] = linode_credential_config
        __props__.__dict__["name"] = name
        __props__.__dict__["openstack_credential_config"] = openstack_credential_config
        __props__.__dict__["vsphere_credential_config"] = vsphere_credential_config
        return CloudCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonec2CredentialConfig")
    def amazonec2_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialAmazonec2CredentialConfig']]:
        """
        AWS config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "amazonec2_credential_config")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for Cloud Credential object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="azureCredentialConfig")
    def azure_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialAzureCredentialConfig']]:
        """
        Azure config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "azure_credential_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description for the Cloud Credential (string)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="digitaloceanCredentialConfig")
    def digitalocean_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialDigitaloceanCredentialConfig']]:
        """
        DigitalOcean config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "digitalocean_credential_config")

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Output[str]:
        """
        (Computed) The driver of the Cloud Credential (string)
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="googleCredentialConfig")
    def google_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialGoogleCredentialConfig']]:
        """
        Google config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "google_credential_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for Cloud Credential object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linodeCredentialConfig")
    def linode_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialLinodeCredentialConfig']]:
        """
        Linode config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "linode_credential_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Cloud Credential (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openstackCredentialConfig")
    def openstack_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialOpenstackCredentialConfig']]:
        """
        OpenStack config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "openstack_credential_config")

    @property
    @pulumi.getter(name="vsphereCredentialConfig")
    def vsphere_credential_config(self) -> pulumi.Output[Optional['outputs.CloudCredentialVsphereCredentialConfig']]:
        """
        vSphere config for the Cloud Credential (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_credential_config")

