# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'access_key',
    'api_url',
    'bootstrap',
    'ca_certs',
    'insecure',
    'retries',
    'secret_key',
    'timeout',
    'token_key',
]

__config__ = pulumi.Config('rancher2')

access_key = __config__.get('accessKey')
"""
API Key used to authenticate with the rancher server
"""

api_url = __config__.get('apiUrl')
"""
The URL to the rancher API
"""

bootstrap = __config__.get('bootstrap') or (_utilities.get_env_bool('RANCHER_BOOTSTRAP') or False)
"""
Bootstrap rancher server
"""

ca_certs = __config__.get('caCerts')
"""
CA certificates used to sign rancher server tls certificates. Mandatory if self signed tls and insecure option false
"""

insecure = __config__.get('insecure') or (_utilities.get_env_bool('RANCHER_INSECURE') or False)
"""
Allow insecure connections to Rancher. Mandatory if self signed tls and not ca_certs provided
"""

retries = __config__.get('retries')
"""
Rancher connection retries
"""

secret_key = __config__.get('secretKey')
"""
API secret used to authenticate with the rancher server
"""

timeout = __config__.get('timeout')
"""
Rancher connection timeout (retry every 5s). Golang duration format, ex: "60s"
"""

token_key = __config__.get('tokenKey')
"""
API token used to authenticate with the rancher server
"""

