# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetCatalogResult',
    'AwaitableGetCatalogResult',
    'get_catalog',
]

@pulumi.output_type
class GetCatalogResult:
    """
    A collection of values returned by getCatalog.
    """
    def __init__(__self__, annotations=None, branch=None, cluster_id=None, description=None, id=None, kind=None, labels=None, name=None, password=None, project_id=None, scope=None, url=None, username=None, version=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if branch and not isinstance(branch, str):
            raise TypeError("Expected argument 'branch' to be a str")
        pulumi.set(__self__, "branch", branch)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, Any]:
        """
        (Computed) Annotations for the catalog (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        (Computed) The branch of the catalog repo to use (string)
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        (Computed) The cluster id of the catalog (string)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        (Computed) A catalog description (string)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        (Computed) The kind of the catalog. Just helm by the moment (string)
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        """
        (Computed) Labels for the catalog (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Computed/Sensitive) The password to access the catalog if needed (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        (Computed) The project id of the catalog (string)
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        (Computed) The url of the catalog repo (string)
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Computed/Sensitive) The username to access the catalog if needed (string)
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        (Computed) Helm version for the catalog (string)
        """
        return pulumi.get(self, "version")


class AwaitableGetCatalogResult(GetCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogResult(
            annotations=self.annotations,
            branch=self.branch,
            cluster_id=self.cluster_id,
            description=self.description,
            id=self.id,
            kind=self.kind,
            labels=self.labels,
            name=self.name,
            password=self.password,
            project_id=self.project_id,
            scope=self.scope,
            url=self.url,
            username=self.username,
            version=self.version)


def get_catalog(name: Optional[str] = None,
                scope: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogResult:
    """
    Use this data source to retrieve information about a Rancher v2 catalog.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    library = rancher2.get_catalog(name="catalog")
    ```


    :param str name: The catalog name.
    :param str scope: The scope of the catalog. `cluster`, `global`, and `project` are supported. Default `global` (string)
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['scope'] = scope
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('rancher2:index/getCatalog:getCatalog', __args__, opts=opts, typ=GetCatalogResult).value

    return AwaitableGetCatalogResult(
        annotations=__ret__.annotations,
        branch=__ret__.branch,
        cluster_id=__ret__.cluster_id,
        description=__ret__.description,
        id=__ret__.id,
        kind=__ret__.kind,
        labels=__ret__.labels,
        name=__ret__.name,
        password=__ret__.password,
        project_id=__ret__.project_id,
        scope=__ret__.scope,
        url=__ret__.url,
        username=__ret__.username,
        version=__ret__.version)
