# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetMultiClusterAppResult',
    'AwaitableGetMultiClusterAppResult',
    'get_multi_cluster_app',
]

@pulumi.output_type
class GetMultiClusterAppResult:
    """
    A collection of values returned by getMultiClusterApp.
    """
    def __init__(__self__, annotations=None, answers=None, catalog_name=None, id=None, labels=None, members=None, name=None, revision_history_limit=None, revision_id=None, roles=None, targets=None, template_name=None, template_version=None, template_version_id=None, upgrade_strategies=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if answers and not isinstance(answers, list):
            raise TypeError("Expected argument 'answers' to be a list")
        pulumi.set(__self__, "answers", answers)
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if revision_history_limit and not isinstance(revision_history_limit, int):
            raise TypeError("Expected argument 'revision_history_limit' to be a int")
        pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)
        if template_version and not isinstance(template_version, str):
            raise TypeError("Expected argument 'template_version' to be a str")
        pulumi.set(__self__, "template_version", template_version)
        if template_version_id and not isinstance(template_version_id, str):
            raise TypeError("Expected argument 'template_version_id' to be a str")
        pulumi.set(__self__, "template_version_id", template_version_id)
        if upgrade_strategies and not isinstance(upgrade_strategies, list):
            raise TypeError("Expected argument 'upgrade_strategies' to be a list")
        pulumi.set(__self__, "upgrade_strategies", upgrade_strategies)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, Any]:
        """
        (Computed) Annotations for multi cluster app object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def answers(self) -> Sequence['outputs.GetMultiClusterAppAnswerResult']:
        """
        (Computed) The multi cluster app answers (list)
        """
        return pulumi.get(self, "answers")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> str:
        """
        (Computed) The multi cluster app catalog name (string)
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        """
        (Computed) Labels for multi cluster app object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetMultiClusterAppMemberResult']:
        """
        (Computed) The multi cluster app members (list)
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> int:
        """
        (Computed) The multi cluster app revision history limit (int)
        """
        return pulumi.get(self, "revision_history_limit")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        (Computed) Current revision id for the multi cluster app (string)
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        (Computed) The multi cluster app roles (list)
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetMultiClusterAppTargetResult']:
        """
        (Computed) The multi cluster app target projects (list)
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> str:
        """
        (Computed) The multi cluster app template name (string)
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> str:
        """
        (Computed) The multi cluster app template version (string)
        """
        return pulumi.get(self, "template_version")

    @property
    @pulumi.getter(name="templateVersionId")
    def template_version_id(self) -> str:
        """
        (Computed) The multi cluster app template version ID (string)
        """
        return pulumi.get(self, "template_version_id")

    @property
    @pulumi.getter(name="upgradeStrategies")
    def upgrade_strategies(self) -> Sequence['outputs.GetMultiClusterAppUpgradeStrategyResult']:
        """
        (Computed) The multi cluster app upgrade strategy (list)
        """
        return pulumi.get(self, "upgrade_strategies")


class AwaitableGetMultiClusterAppResult(GetMultiClusterAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMultiClusterAppResult(
            annotations=self.annotations,
            answers=self.answers,
            catalog_name=self.catalog_name,
            id=self.id,
            labels=self.labels,
            members=self.members,
            name=self.name,
            revision_history_limit=self.revision_history_limit,
            revision_id=self.revision_id,
            roles=self.roles,
            targets=self.targets,
            template_name=self.template_name,
            template_version=self.template_version,
            template_version_id=self.template_version_id,
            upgrade_strategies=self.upgrade_strategies)


def get_multi_cluster_app(name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMultiClusterAppResult:
    """
    Use this data source to retrieve information about a Rancher v2 multi cluster app.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_multi_cluster_app(name="foo")
    ```


    :param str name: The multi cluster app name (string)
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('rancher2:index/getMultiClusterApp:getMultiClusterApp', __args__, opts=opts, typ=GetMultiClusterAppResult).value

    return AwaitableGetMultiClusterAppResult(
        annotations=__ret__.annotations,
        answers=__ret__.answers,
        catalog_name=__ret__.catalog_name,
        id=__ret__.id,
        labels=__ret__.labels,
        members=__ret__.members,
        name=__ret__.name,
        revision_history_limit=__ret__.revision_history_limit,
        revision_id=__ret__.revision_id,
        roles=__ret__.roles,
        targets=__ret__.targets,
        template_name=__ret__.template_name,
        template_version=__ret__.template_version,
        template_version_id=__ret__.template_version_id,
        upgrade_strategies=__ret__.upgrade_strategies)
