# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from mtmai.gomtmclients.rest.models.browser_params import BrowserParams
from mtmai.gomtmclients.rest.models.canvas_graph_params import CanvasGraphParams
from mtmai.gomtmclients.rest.models.crew_ai_params import CrewAIParams
from mtmai.gomtmclients.rest.models.research_request import ResearchRequest
from mtmai.gomtmclients.rest.models.scrape_graph_params import ScrapeGraphParams
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

AGENTNODERUNINPUTPARAMS_ONE_OF_SCHEMAS = ["BrowserParams", "CanvasGraphParams", "CrewAIParams", "ResearchRequest", "ScrapeGraphParams"]

class AgentNodeRunInputParams(BaseModel):
    """
    AgentNodeRunInputParams
    """
    # data type: ResearchRequest
    oneof_schema_1_validator: Optional[ResearchRequest] = None
    # data type: CrewAIParams
    oneof_schema_2_validator: Optional[CrewAIParams] = None
    # data type: ScrapeGraphParams
    oneof_schema_3_validator: Optional[ScrapeGraphParams] = None
    # data type: BrowserParams
    oneof_schema_4_validator: Optional[BrowserParams] = None
    # data type: CanvasGraphParams
    oneof_schema_5_validator: Optional[CanvasGraphParams] = None
    actual_instance: Optional[Union[BrowserParams, CanvasGraphParams, CrewAIParams, ResearchRequest, ScrapeGraphParams]] = None
    one_of_schemas: Set[str] = { "BrowserParams", "CanvasGraphParams", "CrewAIParams", "ResearchRequest", "ScrapeGraphParams" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AgentNodeRunInputParams.model_construct()
        error_messages = []
        match = 0
        # validate data type: ResearchRequest
        if not isinstance(v, ResearchRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResearchRequest`")
        else:
            match += 1
        # validate data type: CrewAIParams
        if not isinstance(v, CrewAIParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CrewAIParams`")
        else:
            match += 1
        # validate data type: ScrapeGraphParams
        if not isinstance(v, ScrapeGraphParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ScrapeGraphParams`")
        else:
            match += 1
        # validate data type: BrowserParams
        if not isinstance(v, BrowserParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BrowserParams`")
        else:
            match += 1
        # validate data type: CanvasGraphParams
        if not isinstance(v, CanvasGraphParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CanvasGraphParams`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AgentNodeRunInputParams with oneOf schemas: BrowserParams, CanvasGraphParams, CrewAIParams, ResearchRequest, ScrapeGraphParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AgentNodeRunInputParams with oneOf schemas: BrowserParams, CanvasGraphParams, CrewAIParams, ResearchRequest, ScrapeGraphParams. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ResearchRequest
        try:
            instance.actual_instance = ResearchRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CrewAIParams
        try:
            instance.actual_instance = CrewAIParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ScrapeGraphParams
        try:
            instance.actual_instance = ScrapeGraphParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BrowserParams
        try:
            instance.actual_instance = BrowserParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CanvasGraphParams
        try:
            instance.actual_instance = CanvasGraphParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AgentNodeRunInputParams with oneOf schemas: BrowserParams, CanvasGraphParams, CrewAIParams, ResearchRequest, ScrapeGraphParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AgentNodeRunInputParams with oneOf schemas: BrowserParams, CanvasGraphParams, CrewAIParams, ResearchRequest, ScrapeGraphParams. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], BrowserParams, CanvasGraphParams, CrewAIParams, ResearchRequest, ScrapeGraphParams]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


