# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from mtmai.gomtmclients.rest.models.assisant_state import AssisantState
from mtmai.gomtmclients.rest.models.blog_task_state import BlogTaskState
from mtmai.gomtmclients.rest.models.evt_node_step import EvtNodeStep
from mtmai.gomtmclients.rest.models.gen_article_state import GenArticleState
from mtmai.gomtmclients.rest.models.postiz_state import PostizState
from mtmai.gomtmclients.rest.models.token_chunk import TokenChunk
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

AGENTSTATE_ONE_OF_SCHEMAS = ["AssisantState", "BlogTaskState", "EvtNodeStep", "GenArticleState", "PostizState", "TokenChunk"]

class AgentState(BaseModel):
    """
    AgentState
    """
    # data type: AssisantState
    oneof_schema_1_validator: Optional[AssisantState] = None
    # data type: GenArticleState
    oneof_schema_2_validator: Optional[GenArticleState] = None
    # data type: BlogTaskState
    oneof_schema_3_validator: Optional[BlogTaskState] = None
    # data type: PostizState
    oneof_schema_4_validator: Optional[PostizState] = None
    # data type: TokenChunk
    oneof_schema_5_validator: Optional[TokenChunk] = None
    # data type: EvtNodeStep
    oneof_schema_6_validator: Optional[EvtNodeStep] = None
    actual_instance: Optional[Union[AssisantState, BlogTaskState, EvtNodeStep, GenArticleState, PostizState, TokenChunk]] = None
    one_of_schemas: Set[str] = { "AssisantState", "BlogTaskState", "EvtNodeStep", "GenArticleState", "PostizState", "TokenChunk" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AgentState.model_construct()
        error_messages = []
        match = 0
        # validate data type: AssisantState
        if not isinstance(v, AssisantState):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AssisantState`")
        else:
            match += 1
        # validate data type: GenArticleState
        if not isinstance(v, GenArticleState):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GenArticleState`")
        else:
            match += 1
        # validate data type: BlogTaskState
        if not isinstance(v, BlogTaskState):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BlogTaskState`")
        else:
            match += 1
        # validate data type: PostizState
        if not isinstance(v, PostizState):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PostizState`")
        else:
            match += 1
        # validate data type: TokenChunk
        if not isinstance(v, TokenChunk):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TokenChunk`")
        else:
            match += 1
        # validate data type: EvtNodeStep
        if not isinstance(v, EvtNodeStep):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EvtNodeStep`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AgentState with oneOf schemas: AssisantState, BlogTaskState, EvtNodeStep, GenArticleState, PostizState, TokenChunk. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AgentState with oneOf schemas: AssisantState, BlogTaskState, EvtNodeStep, GenArticleState, PostizState, TokenChunk. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AssisantState
        try:
            instance.actual_instance = AssisantState.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GenArticleState
        try:
            instance.actual_instance = GenArticleState.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BlogTaskState
        try:
            instance.actual_instance = BlogTaskState.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PostizState
        try:
            instance.actual_instance = PostizState.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TokenChunk
        try:
            instance.actual_instance = TokenChunk.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into EvtNodeStep
        try:
            instance.actual_instance = EvtNodeStep.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AgentState with oneOf schemas: AssisantState, BlogTaskState, EvtNodeStep, GenArticleState, PostizState, TokenChunk. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AgentState with oneOf schemas: AssisantState, BlogTaskState, EvtNodeStep, GenArticleState, PostizState, TokenChunk. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AssisantState, BlogTaskState, EvtNodeStep, GenArticleState, PostizState, TokenChunk]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


