# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class CustomQuickAction(BaseModel):
    """
    CustomQuickAction
    """ # noqa: E501
    id: StrictStr = Field(description="A UUID for the quick action. Used to identify the quick action.")
    title: StrictStr = Field(description="The title of the quick action. Used in the UI to display the quick action.")
    prompt: StrictStr = Field(description="The prompt to use when the quick action is invoked.")
    include_reflections: StrictBool = Field(description="Whether or not to include the user's reflections in the prompt.", alias="includeReflections")
    include_prefix: StrictBool = Field(description="Whether or not to include the default prefix in the prompt.", alias="includePrefix")
    include_recent_history: StrictBool = Field(description="Whether or not to include the last 5 (or less) messages in the prompt.", alias="includeRecentHistory")
    __properties: ClassVar[List[str]] = ["id", "title", "prompt", "includeReflections", "includePrefix", "includeRecentHistory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomQuickAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomQuickAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "prompt": obj.get("prompt"),
            "includeReflections": obj.get("includeReflections"),
            "includePrefix": obj.get("includePrefix"),
            "includeRecentHistory": obj.get("includeRecentHistory")
        })
        return _obj


