# coding: utf-8

"""
    Mtmai API

    The Mtmai API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class FrontendConfig(BaseModel):
    """
    FrontendConfig
    """ # noqa: E501
    cookie_access_token: StrictStr = Field(description="Cookie access token", alias="cookieAccessToken")
    dash_path: StrictStr = Field(description="Dashboard path", alias="dashPath")
    hot_key_debug: StrictStr = Field(description="Hot key debug", alias="hotKeyDebug")
    default_tenant_access_token: StrictStr = Field(description="实验性质，默认租户的access token", alias="defaultTenantAccessToken")
    __properties: ClassVar[List[str]] = ["cookieAccessToken", "dashPath", "hotKeyDebug", "defaultTenantAccessToken"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FrontendConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FrontendConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cookieAccessToken": obj.get("cookieAccessToken"),
            "dashPath": obj.get("dashPath"),
            "hotKeyDebug": obj.get("hotKeyDebug"),
            "defaultTenantAccessToken": obj.get("defaultTenantAccessToken")
        })
        return _obj


