from typing import overload
from enum import IntEnum
import datetime
import typing

import QuantConnect.Data
import QuantConnect.Data.Custom
import QuantConnect.DataSource


class Quandl(QuantConnect.DataSource.NasdaqDataLink):
    """Quandl Data Type (Deprecated, Use NasdaqDataLink instead.)"""

    @overload
    def __init__(self) -> None:
        """Default Quandl constructor uses Close as its value column"""
        ...

    @overload
    def __init__(self, value_column_name: str) -> None:
        """
        Constructor for creating customized Quandl instance which doesn't use close, price, settle or value as its value item.
        
        
        This codeEntityType is protected.
        
        :param value_column_name: The name of the column we want to use as reference, the Value property
        """
        ...


class FxcmVolume(QuantConnect.Data.BaseData):
    """
    FXCM Real FOREX Volume and Transaction data from its clients base, available for the following pairs:
        - EURUSD, USDJPY, GBPUSD, USDCHF, EURCHF, AUDUSD, USDCAD,
          NZDUSD, EURGBP, EURJPY, GBPJPY, EURAUD, EURCAD, AUDJPY
        FXCM only provides support for FX symbols which produced over 110 million average daily volume (ADV) during 2013.
        This limit is imposed to ensure we do not highlight low volume/low ticket symbols in addition to other financial
        reporting concerns.
    """

    @property
    def transactions(self) -> int:
        """Sum of opening and closing Transactions for the entire time interval."""
        ...

    @transactions.setter
    def transactions(self, value: int) -> None:
        ...

    @property
    def volume(self) -> int:
        """
        Sum of opening and closing Volume for the entire time interval.
            The volume measured in the QUOTE CURRENCY.
        """
        ...

    @volume.setter
    def volume(self, value: int) -> None:
        ...

    def get_source(self, config: QuantConnect.Data.SubscriptionDataConfig, date: datetime.datetime, is_live_mode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param is_live_mode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: datetime.datetime, is_live_mode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects. Each data type creates its own factory method,
            and returns a new instance of the object
            each time it is called. The returned object is assumed to be time stamped in the config.ExchangeTimeZone.
        
        :param config: Subscription data config setup object
        :param line: Line of the source document
        :param date: Date of the requested data
        :param is_live_mode: true if we're in live mode, false for backtesting mode
        :returns: Instance of the T:BaseData object generated by this line of the CSV.
        """
        ...


